/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.limiter;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.pipe.config.PipeConfig;

public class GlobalRateLimiter {
    private static final PipeConfig CONFIG = PipeConfig.getInstance();
    private final AtomicDouble throughputBytesPerSecond = new AtomicDouble(CONFIG.getPipeAllConnectorsRateLimitBytesPerSecond());
    private final RateLimiter rateLimiter;

    public GlobalRateLimiter() {
        double throughputBytesPerSecondLimit = this.throughputBytesPerSecond.get();
        this.rateLimiter = throughputBytesPerSecondLimit <= 0.0 ? RateLimiter.create((double)Double.MAX_VALUE) : RateLimiter.create((double)throughputBytesPerSecondLimit);
    }

    public void acquire(long bytes) {
        if (this.reloadParams()) {
            return;
        }
        while (bytes > 0L) {
            if (bytes > Integer.MAX_VALUE) {
                this.tryAcquireWithRateCheck(Integer.MAX_VALUE);
                bytes -= Integer.MAX_VALUE;
                continue;
            }
            this.tryAcquireWithRateCheck((int)bytes);
            return;
        }
    }

    private void tryAcquireWithRateCheck(int bytes) {
        while (!this.rateLimiter.tryAcquire(bytes, (long)PipeConfig.getInstance().getRateLimiterHotReloadCheckIntervalMs(), TimeUnit.MILLISECONDS)) {
            if (!this.reloadParams()) continue;
            return;
        }
    }

    private boolean reloadParams() {
        double throughputBytesPerSecondLimit = CONFIG.getPipeAllConnectorsRateLimitBytesPerSecond();
        if (this.throughputBytesPerSecond.get() != throughputBytesPerSecondLimit) {
            this.throughputBytesPerSecond.set(throughputBytesPerSecondLimit);
            this.rateLimiter.setRate(throughputBytesPerSecondLimit <= 0.0 ? Double.MAX_VALUE : throughputBytesPerSecondLimit);
        }
        return throughputBytesPerSecondLimit <= 0.0;
    }
}

