/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class SemanticChangeStructureDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=897");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=898");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=899");
    private final NodeId affected;
    private final NodeId affectedType;

    public SemanticChangeStructureDataType(NodeId affected, NodeId affectedType) {
        this.affected = affected;
        this.affectedType = affectedType;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public NodeId getAffected() {
        return this.affected;
    }

    public NodeId getAffectedType() {
        return this.affectedType;
    }

    protected SemanticChangeStructureDataType(SemanticChangeStructureDataTypeBuilder<?, ?> b) {
        super(b);
        this.affected = ((SemanticChangeStructureDataTypeBuilder)b).affected;
        this.affectedType = ((SemanticChangeStructureDataTypeBuilder)b).affectedType;
    }

    public static SemanticChangeStructureDataTypeBuilder<?, ?> builder() {
        return new SemanticChangeStructureDataTypeBuilderImpl();
    }

    public SemanticChangeStructureDataTypeBuilder<?, ?> toBuilder() {
        return new SemanticChangeStructureDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SemanticChangeStructureDataType)) {
            return false;
        }
        SemanticChangeStructureDataType other = (SemanticChangeStructureDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$affected = this.getAffected();
        NodeId other$affected = other.getAffected();
        if (this$affected == null ? other$affected != null : !((Object)this$affected).equals(other$affected)) {
            return false;
        }
        NodeId this$affectedType = this.getAffectedType();
        NodeId other$affectedType = other.getAffectedType();
        return !(this$affectedType == null ? other$affectedType != null : !((Object)this$affectedType).equals(other$affectedType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SemanticChangeStructureDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $affected = this.getAffected();
        result = result * 59 + ($affected == null ? 43 : ((Object)$affected).hashCode());
        NodeId $affectedType = this.getAffectedType();
        result = result * 59 + ($affectedType == null ? 43 : ((Object)$affectedType).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SemanticChangeStructureDataType(affected=" + this.getAffected() + ", affectedType=" + this.getAffectedType() + ")";
    }

    private static final class SemanticChangeStructureDataTypeBuilderImpl
    extends SemanticChangeStructureDataTypeBuilder<SemanticChangeStructureDataType, SemanticChangeStructureDataTypeBuilderImpl> {
        private SemanticChangeStructureDataTypeBuilderImpl() {
        }

        @Override
        protected SemanticChangeStructureDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public SemanticChangeStructureDataType build() {
            return new SemanticChangeStructureDataType(this);
        }
    }

    public static abstract class SemanticChangeStructureDataTypeBuilder<C extends SemanticChangeStructureDataType, B extends SemanticChangeStructureDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId affected;
        private NodeId affectedType;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SemanticChangeStructureDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SemanticChangeStructureDataType instance, SemanticChangeStructureDataTypeBuilder<?, ?> b) {
            b.affected(instance.affected);
            b.affectedType(instance.affectedType);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B affected(NodeId affected) {
            this.affected = affected;
            return (B)this.self();
        }

        public B affectedType(NodeId affectedType) {
            this.affectedType = affectedType;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SemanticChangeStructureDataType.SemanticChangeStructureDataTypeBuilder(super=" + super.toString() + ", affected=" + this.affected + ", affectedType=" + this.affectedType + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SemanticChangeStructureDataType> {
        @Override
        public Class<SemanticChangeStructureDataType> getType() {
            return SemanticChangeStructureDataType.class;
        }

        @Override
        public SemanticChangeStructureDataType decode(SerializationContext context, UaDecoder decoder) {
            NodeId affected = decoder.readNodeId("Affected");
            NodeId affectedType = decoder.readNodeId("AffectedType");
            return new SemanticChangeStructureDataType(affected, affectedType);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SemanticChangeStructureDataType value) {
            encoder.writeNodeId("Affected", value.getAffected());
            encoder.writeNodeId("AffectedType", value.getAffectedType());
        }
    }
}

