/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.sys;

import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;

public class ExplainAnalyzeStatement
extends Statement {
    private final QueryStatement queryStatement;
    private boolean verbose = false;

    public ExplainAnalyzeStatement(QueryStatement queryStatement) {
        this.statementType = StatementType.QUERY;
        this.queryStatement = queryStatement;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        return this.queryStatement.checkPermissionBeforeProcess(userName);
    }

    public QueryStatement getQueryStatement() {
        return this.queryStatement;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.queryStatement.getPaths();
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitExplainAnalyze(this, context);
    }
}

