/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.PostOffice;
import io.moquette.broker.SharedSubscriptionUtils;
import io.moquette.broker.Utils;
import io.moquette.broker.security.IAuthorizatorPolicy;
import io.moquette.broker.subscriptions.Topic;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Authorizator {
    private static final Logger LOG = LoggerFactory.getLogger(Authorizator.class);
    private final IAuthorizatorPolicy policy;
    private ConcurrentMap<Utils.Couple<Topic, String>, Boolean> responseTopicForcedReads = new ConcurrentHashMap<Utils.Couple<Topic, String>, Boolean>();
    private ConcurrentMap<Topic, Boolean> responseTopicForcedWrites = new ConcurrentHashMap<Topic, Boolean>();

    Authorizator(IAuthorizatorPolicy policy) {
        this.policy = policy;
    }

    List<MqttTopicSubscription> verifyAlsoSharedTopicsReadAccess(String clientID, String username, MqttSubscribeMessage msg) {
        return this.verifyTopicsReadAccessWithTopicExtractor(clientID, username, msg, Authorizator::extractShareTopic);
    }

    private static Topic extractShareTopic(String s) {
        if (SharedSubscriptionUtils.isSharedSubscription(s)) {
            return Topic.asTopic(SharedSubscriptionUtils.extractFilterFromShared(s));
        }
        return Topic.asTopic(s);
    }

    List<MqttTopicSubscription> verifyTopicsReadAccess(String clientID, String username, MqttSubscribeMessage msg) {
        return this.verifyTopicsReadAccessWithTopicExtractor(clientID, username, msg, Topic::asTopic);
    }

    private List<MqttTopicSubscription> verifyTopicsReadAccessWithTopicExtractor(String clientID, String username, MqttSubscribeMessage msg, Function<String, Topic> topicExtractor) {
        ArrayList<MqttTopicSubscription> ackTopics = new ArrayList<MqttTopicSubscription>();
        int messageId = Utils.messageId((MqttMessage)msg);
        for (MqttTopicSubscription req : msg.payload().topicSubscriptions()) {
            Topic topic = topicExtractor.apply(req.topicName());
            MqttQoS qos = this.getQoSCheckingAlsoPermissionsOnTopic(clientID, username, messageId, topic, req.qualityOfService());
            MqttSubscriptionOption option = PostOffice.optionWithQos(qos, req.option());
            ackTopics.add(new MqttTopicSubscription(req.topicName(), option));
        }
        return ackTopics;
    }

    private MqttQoS getQoSCheckingAlsoPermissionsOnTopic(String clientID, String username, int messageId, Topic topic, MqttQoS requestedQoS) {
        if (this.policy.canRead(topic, username, clientID)) {
            if (topic.isValid()) {
                LOG.debug("Client will be subscribed to the topic username: {}, messageId: {}, topic: {}", new Object[]{username, messageId, topic});
                return requestedQoS;
            }
            LOG.warn("Topic filter is not valid username: {}, messageId: {}, topic: {}", new Object[]{username, messageId, topic});
            return MqttQoS.FAILURE;
        }
        LOG.warn("Client does not have read permissions on the topic username: {}, messageId: {}, topic: {}", new Object[]{username, messageId, topic});
        return MqttQoS.FAILURE;
    }

    boolean canWrite(Topic topic, String user, String client) {
        boolean policyResult = this.policy.canWrite(topic, user, client);
        if (!policyResult && this.responseTopicForcedWrites.containsKey(topic)) {
            LOG.warn("Found write discord by policy and response information topic configured. The policy prohibit while the response topic should be accessible for all to write. topic: {}", (Object)topic);
            return true;
        }
        return policyResult;
    }

    boolean canRead(Topic topic, String user, String client) {
        boolean policyResult = this.policy.canRead(topic, user, client);
        if (!policyResult && this.responseTopicForcedReads.containsKey(Utils.Couple.of(topic, client))) {
            LOG.warn("Found read discord by policy and response information topic configured. The policy prohibit while the response topic should be accessible by read from client{}. topic: {}", (Object)client, (Object)topic);
            return true;
        }
        return policyResult;
    }

    void forceReadAccess(Topic topic, String client) {
        this.responseTopicForcedReads.putIfAbsent(Utils.Couple.of(topic, client), true);
    }

    public void forceWriteToAll(Topic topic) {
        this.responseTopicForcedWrites.putIfAbsent(topic, true);
    }
}

