/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GorillaDecoderV1
extends Decoder {
    protected static final int EOF = -1;
    private static final Logger logger = LoggerFactory.getLogger(GorillaDecoderV1.class);
    protected boolean flag;
    protected int leadingZeroNum;
    protected int tailingZeroNum;
    protected boolean isEnd;
    protected int buffer;
    protected int numberLeftInBuffer;
    protected boolean nextFlag1;
    protected boolean nextFlag2;

    protected GorillaDecoderV1() {
        super(TSEncoding.GORILLA_V1);
        this.reset();
    }

    @Override
    public void reset() {
        this.flag = false;
        this.isEnd = false;
        this.numberLeftInBuffer = 0;
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) throws IOException {
        return buffer.remaining() > 0 || !this.isEnd;
    }

    protected boolean isEmpty() {
        return this.buffer == -1;
    }

    protected boolean readBit(ByteBuffer buffer) throws IOException {
        if (this.numberLeftInBuffer == 0 && !this.isEnd) {
            this.fillBuffer(buffer);
        }
        if (this.isEmpty()) {
            throw new IOException("Reading from empty buffer");
        }
        --this.numberLeftInBuffer;
        return (this.buffer >> this.numberLeftInBuffer & 1) == 1;
    }

    protected void fillBuffer(ByteBuffer buffer) {
        if (buffer.remaining() >= 1) {
            this.buffer = ReadWriteIOUtils.read(buffer);
            this.numberLeftInBuffer = 8;
        } else {
            logger.error("Failed to fill a new buffer, because there is no byte to read");
            this.buffer = -1;
            this.numberLeftInBuffer = -1;
        }
    }

    protected int readIntFromStream(ByteBuffer buffer, int len) throws IOException {
        int num = 0;
        for (int i = 0; i < len; ++i) {
            int bit = this.readBit(buffer) ? 1 : 0;
            num |= bit << len - 1 - i;
        }
        return num;
    }

    protected long readLongFromStream(ByteBuffer buffer, int len) throws IOException {
        long num = 0L;
        for (int i = 0; i < len; ++i) {
            long bit = this.readBit(buffer) ? 1L : 0L;
            num |= bit << len - 1 - i;
        }
        return num;
    }
}

