/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.encoding.decoder.IntRleDecoder;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryDecoder
extends Decoder {
    private static final Logger logger = LoggerFactory.getLogger(DictionaryDecoder.class);
    private List<Binary> entryIndex;
    private IntRleDecoder valueDecoder = new IntRleDecoder();

    public DictionaryDecoder() {
        super(TSEncoding.DICTIONARY);
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) {
        if (this.entryIndex == null) {
            this.initMap(buffer);
        }
        try {
            return this.valueDecoder.hasNext(buffer);
        }
        catch (IOException e) {
            logger.error("tsfile-decoding DictionaryDecoder: error occurs when decoding", (Throwable)e);
            return false;
        }
    }

    @Override
    public Binary readBinary(ByteBuffer buffer) {
        if (this.entryIndex == null) {
            this.initMap(buffer);
        }
        int code = this.valueDecoder.readInt(buffer);
        return this.entryIndex.get(code);
    }

    private void initMap(ByteBuffer buffer) {
        int length = ReadWriteForEncodingUtils.readVarInt(buffer);
        this.entryIndex = new ArrayList<Binary>(length);
        for (int i = 0; i < length; ++i) {
            int binaryLength = ReadWriteForEncodingUtils.readVarInt(buffer);
            byte[] buf = new byte[binaryLength];
            buffer.get(buf, 0, binaryLength);
            this.entryIndex.add(new Binary(buf));
        }
    }

    @Override
    public void reset() {
        this.entryIndex = null;
        this.valueDecoder.reset();
    }
}

