/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TokenType {
    ACCESS_TOKEN("urn:ietf:params:oauth:token-type:access_token"),
    REFRESH_TOKEN("urn:ietf:params:oauth:token-type:refresh_token"),
    ID_TOKEN("urn:ietf:params:oauth:token-type:id_token"),
    SAML1("urn:ietf:params:oauth:token-type:saml1"),
    SAML2("urn:ietf:params:oauth:token-type:saml2"),
    JWT("urn:ietf:params:oauth:token-type:jwt");

    private final String value;

    private TokenType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static TokenType fromString(String value) {
        for (TokenType b : TokenType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

