/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ListMultimap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.transforms.UnknownTransform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class PartitionSpec
implements Serializable {
    private static final int PARTITION_DATA_ID_START = 1000;
    private final Schema schema;
    private final int specId;
    private final PartitionField[] fields;
    private volatile transient ListMultimap<Integer, PartitionField> fieldsBySourceId = null;
    private volatile transient Class<?>[] lazyJavaClasses = null;
    private volatile transient Types.StructType lazyPartitionType = null;
    private volatile transient Types.StructType lazyRawPartitionType = null;
    private volatile transient List<PartitionField> fieldList = null;
    private final int lastAssignedFieldId;
    private static final PartitionSpec UNPARTITIONED_SPEC = new PartitionSpec(new Schema(new Types.NestedField[0]), 0, (List<PartitionField>)ImmutableList.of(), PartitionSpec.unpartitionedLastAssignedId());

    private PartitionSpec(Schema schema, int specId, List<PartitionField> fields, int lastAssignedFieldId) {
        this.schema = schema;
        this.specId = specId;
        this.fields = fields.toArray(new PartitionField[0]);
        this.lastAssignedFieldId = lastAssignedFieldId;
    }

    public Schema schema() {
        return this.schema;
    }

    public int specId() {
        return this.specId;
    }

    public List<PartitionField> fields() {
        return this.lazyFieldList();
    }

    public boolean isPartitioned() {
        return this.fields.length > 0 && this.fields().stream().anyMatch(f -> !f.transform().isVoid());
    }

    public boolean isUnpartitioned() {
        return !this.isPartitioned();
    }

    int lastAssignedFieldId() {
        return this.lastAssignedFieldId;
    }

    public UnboundPartitionSpec toUnbound() {
        UnboundPartitionSpec.Builder builder = UnboundPartitionSpec.builder().withSpecId(this.specId);
        for (PartitionField field : this.fields) {
            builder.addField(field.transform().toString(), field.sourceId(), field.fieldId(), field.name());
        }
        return builder.build();
    }

    public List<PartitionField> getFieldsBySourceId(int fieldId) {
        return this.lazyFieldsBySourceId().get((Object)fieldId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Types.StructType partitionType() {
        if (this.lazyPartitionType == null) {
            PartitionSpec partitionSpec = this;
            synchronized (partitionSpec) {
                if (this.lazyPartitionType == null) {
                    ArrayList structFields = Lists.newArrayListWithExpectedSize((int)this.fields.length);
                    for (PartitionField field : this.fields) {
                        Type sourceType = this.schema.findType(field.sourceId());
                        Type resultType = field.transform().getResultType(sourceType);
                        structFields.add(Types.NestedField.optional(field.fieldId(), field.name(), resultType));
                    }
                    this.lazyPartitionType = Types.StructType.of(structFields);
                }
            }
        }
        return this.lazyPartitionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Types.StructType rawPartitionType() {
        if (this.schema.idsToOriginal().isEmpty()) {
            return this.partitionType();
        }
        if (this.lazyRawPartitionType == null) {
            PartitionSpec partitionSpec = this;
            synchronized (partitionSpec) {
                if (this.lazyRawPartitionType == null) {
                    this.lazyRawPartitionType = Types.StructType.of(this.partitionType().fields().stream().map(f -> f.withFieldId(this.schema.idsToOriginal().get(f.fieldId()))).collect(Collectors.toList()));
                }
            }
        }
        return this.lazyRawPartitionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?>[] javaClasses() {
        if (this.lazyJavaClasses == null) {
            PartitionSpec partitionSpec = this;
            synchronized (partitionSpec) {
                if (this.lazyJavaClasses == null) {
                    Class[] classes = new Class[this.fields.length];
                    for (int i = 0; i < this.fields.length; ++i) {
                        PartitionField field = this.fields[i];
                        if (field.transform() instanceof UnknownTransform) {
                            classes[i] = Object.class;
                            continue;
                        }
                        Type sourceType = this.schema.findType(field.sourceId());
                        Type result = field.transform().getResultType(sourceType);
                        classes[i] = result.typeId().javaClass();
                    }
                    this.lazyJavaClasses = classes;
                }
            }
        }
        return this.lazyJavaClasses;
    }

    private <T> T get(StructLike data, int pos, Class<?> javaClass) {
        return (T)data.get(pos, javaClass);
    }

    private String escape(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String partitionToPath(StructLike data) {
        StringBuilder sb = new StringBuilder();
        Class<?>[] javaClasses = this.javaClasses();
        List<Types.NestedField> outputFields = this.partitionType().fields();
        for (int i = 0; i < javaClasses.length; ++i) {
            PartitionField field = this.fields[i];
            Type type = outputFields.get(i).type();
            String valueString = field.transform().toHumanString(type, this.get(data, i, javaClasses[i]));
            if (i > 0) {
                sb.append("/");
            }
            sb.append(this.escape(field.name())).append("=").append(this.escape(valueString));
        }
        return sb.toString();
    }

    public boolean compatibleWith(PartitionSpec other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.fields.length != other.fields.length) {
            return false;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            PartitionField thisField = this.fields[i];
            PartitionField thatField = other.fields[i];
            if (thisField.sourceId() == thatField.sourceId() && thisField.transform().toString().equals(thatField.transform().toString()) && thisField.name().equals(thatField.name())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PartitionSpec)) {
            return false;
        }
        PartitionSpec that = (PartitionSpec)other;
        if (this.specId != that.specId) {
            return false;
        }
        return Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return 31 * Integer.hashCode(this.specId) + Arrays.hashCode(this.fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PartitionField> lazyFieldList() {
        if (this.fieldList == null) {
            PartitionSpec partitionSpec = this;
            synchronized (partitionSpec) {
                if (this.fieldList == null) {
                    this.fieldList = ImmutableList.copyOf((Object[])this.fields);
                }
            }
        }
        return this.fieldList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListMultimap<Integer, PartitionField> lazyFieldsBySourceId() {
        if (this.fieldsBySourceId == null) {
            PartitionSpec partitionSpec = this;
            synchronized (partitionSpec) {
                if (this.fieldsBySourceId == null) {
                    ListMultimap multiMap = Multimaps.newListMultimap((Map)Maps.newHashMap(), () -> Lists.newArrayListWithCapacity((int)this.fields.length));
                    for (PartitionField field : this.fields) {
                        multiMap.put((Object)field.sourceId(), (Object)field);
                    }
                    this.fieldsBySourceId = multiMap;
                }
            }
        }
        return this.fieldsBySourceId;
    }

    public Set<Integer> identitySourceIds() {
        HashSet sourceIds = Sets.newHashSet();
        for (PartitionField field : this.fields()) {
            if (!"identity".equals(field.transform().toString())) continue;
            sourceIds.add(field.sourceId());
        }
        return sourceIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (PartitionField field : this.fields) {
            sb.append("\n");
            sb.append("  ").append(field);
        }
        if (this.fields.length > 0) {
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public static PartitionSpec unpartitioned() {
        return UNPARTITIONED_SPEC;
    }

    private static int unpartitionedLastAssignedId() {
        return 999;
    }

    public static Builder builderFor(Schema schema) {
        return new Builder(schema);
    }

    static void checkCompatibility(PartitionSpec spec, Schema schema) {
        for (PartitionField field : spec.fields) {
            Type sourceType = schema.findType(field.sourceId());
            Transform<?, ?> transform = field.transform();
            if (transform.equals(Transforms.alwaysNull())) continue;
            ValidationException.check(sourceType != null, "Cannot find source column for partition field: %s", field);
            ValidationException.check(sourceType.isPrimitiveType(), "Cannot partition by non-primitive source field: %s", sourceType);
            ValidationException.check(transform.canTransform(sourceType), "Invalid source type %s for transform: %s", sourceType, transform);
        }
    }

    static boolean hasSequentialIds(PartitionSpec spec) {
        for (int i = 0; i < spec.fields.length; ++i) {
            if (spec.fields[i].fieldId() == 1000 + i) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private final Schema schema;
        private final List<PartitionField> fields = Lists.newArrayList();
        private final Set<String> partitionNames = Sets.newHashSet();
        private final Map<Map.Entry<Integer, String>, PartitionField> dedupFields = Maps.newHashMap();
        private int specId = 0;
        private final AtomicInteger lastAssignedFieldId = new AtomicInteger(PartitionSpec.unpartitionedLastAssignedId());
        private boolean checkConflicts = true;
        private boolean caseSensitive = true;

        private Builder(Schema schema) {
            this.schema = schema;
        }

        private int nextFieldId() {
            return this.lastAssignedFieldId.incrementAndGet();
        }

        private void checkAndAddPartitionName(String name) {
            this.checkAndAddPartitionName(name, null);
        }

        Builder checkConflicts(boolean check) {
            this.checkConflicts = check;
            return this;
        }

        private void checkAndAddPartitionName(String name, Integer sourceColumnId) {
            Types.NestedField schemaField;
            Types.NestedField nestedField = schemaField = this.caseSensitive ? this.schema.findField(name) : this.schema.caseInsensitiveFindField(name);
            if (this.checkConflicts) {
                if (sourceColumnId != null) {
                    Preconditions.checkArgument((schemaField == null || schemaField.fieldId() == sourceColumnId.intValue() ? 1 : 0) != 0, (String)"Cannot create identity partition sourced from different field in schema: %s", (Object)name);
                } else {
                    Preconditions.checkArgument((schemaField == null ? 1 : 0) != 0, (String)"Cannot create partition from name that exists in schema: %s", (Object)name);
                }
            }
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"Cannot use empty partition name: %s", (Object)name);
            Preconditions.checkArgument((!this.partitionNames.contains(name) ? 1 : 0) != 0, (String)"Cannot use partition name more than once: %s", (Object)name);
            this.partitionNames.add(name);
        }

        private void checkForRedundantPartitions(PartitionField field) {
            AbstractMap.SimpleEntry<Integer, String> dedupKey = new AbstractMap.SimpleEntry<Integer, String>(field.sourceId(), field.transform().dedupName());
            PartitionField partitionField = this.dedupFields.get(dedupKey);
            Preconditions.checkArgument((partitionField == null ? 1 : 0) != 0, (String)"Cannot add redundant partition: %s conflicts with %s", (Object)partitionField, (Object)field);
            this.dedupFields.put(dedupKey, field);
        }

        public Builder caseSensitive(boolean sensitive) {
            this.caseSensitive = sensitive;
            return this;
        }

        public Builder withSpecId(int newSpecId) {
            this.specId = newSpecId;
            return this;
        }

        private Types.NestedField findSourceColumn(String sourceName) {
            Types.NestedField sourceColumn = this.caseSensitive ? this.schema.findField(sourceName) : this.schema.caseInsensitiveFindField(sourceName);
            Preconditions.checkArgument((sourceColumn != null ? 1 : 0) != 0, (String)"Cannot find source column: %s", (Object)sourceName);
            return sourceColumn;
        }

        Builder identity(String sourceName, String targetName) {
            return this.identity(this.findSourceColumn(sourceName), targetName);
        }

        private Builder identity(Types.NestedField sourceColumn, String targetName) {
            this.checkAndAddPartitionName(targetName, sourceColumn.fieldId());
            PartitionField field = new PartitionField(sourceColumn.fieldId(), this.nextFieldId(), targetName, Transforms.identity());
            this.checkForRedundantPartitions(field);
            this.fields.add(field);
            return this;
        }

        public Builder identity(String sourceName) {
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            return this.identity(sourceColumn, this.schema.findColumnName(sourceColumn.fieldId()));
        }

        public Builder year(String sourceName, String targetName) {
            return this.year(this.findSourceColumn(sourceName), targetName);
        }

        private Builder year(Types.NestedField sourceColumn, String targetName) {
            this.checkAndAddPartitionName(targetName);
            PartitionField field = new PartitionField(sourceColumn.fieldId(), this.nextFieldId(), targetName, Transforms.year());
            this.checkForRedundantPartitions(field);
            this.fields.add(field);
            return this;
        }

        public Builder year(String sourceName) {
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            String columnName = this.schema.findColumnName(sourceColumn.fieldId());
            return this.year(sourceColumn, columnName + "_year");
        }

        public Builder month(String sourceName, String targetName) {
            return this.month(this.findSourceColumn(sourceName), targetName);
        }

        private Builder month(Types.NestedField sourceColumn, String targetName) {
            this.checkAndAddPartitionName(targetName);
            PartitionField field = new PartitionField(sourceColumn.fieldId(), this.nextFieldId(), targetName, Transforms.month());
            this.checkForRedundantPartitions(field);
            this.fields.add(field);
            return this;
        }

        public Builder month(String sourceName) {
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            String columnName = this.schema.findColumnName(sourceColumn.fieldId());
            return this.month(sourceColumn, columnName + "_month");
        }

        public Builder day(String sourceName, String targetName) {
            return this.day(this.findSourceColumn(sourceName), targetName);
        }

        private Builder day(Types.NestedField sourceColumn, String targetName) {
            this.checkAndAddPartitionName(targetName);
            PartitionField field = new PartitionField(sourceColumn.fieldId(), this.nextFieldId(), targetName, Transforms.day());
            this.checkForRedundantPartitions(field);
            this.fields.add(field);
            return this;
        }

        public Builder day(String sourceName) {
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            String columnName = this.schema.findColumnName(sourceColumn.fieldId());
            return this.day(sourceColumn, columnName + "_day");
        }

        public Builder hour(String sourceName, String targetName) {
            return this.hour(this.findSourceColumn(sourceName), targetName);
        }

        private Builder hour(Types.NestedField sourceColumn, String targetName) {
            this.checkAndAddPartitionName(targetName);
            PartitionField field = new PartitionField(sourceColumn.fieldId(), this.nextFieldId(), targetName, Transforms.hour());
            this.checkForRedundantPartitions(field);
            this.fields.add(field);
            return this;
        }

        public Builder hour(String sourceName) {
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            String columnName = this.schema.findColumnName(sourceColumn.fieldId());
            return this.hour(sourceColumn, columnName + "_hour");
        }

        public Builder bucket(String sourceName, int numBuckets, String targetName) {
            return this.bucket(this.findSourceColumn(sourceName), numBuckets, targetName);
        }

        private Builder bucket(Types.NestedField sourceColumn, int numBuckets, String targetName) {
            this.checkAndAddPartitionName(targetName);
            this.fields.add(new PartitionField(sourceColumn.fieldId(), this.nextFieldId(), targetName, Transforms.bucket(numBuckets)));
            return this;
        }

        public Builder bucket(String sourceName, int numBuckets) {
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            String columnName = this.schema.findColumnName(sourceColumn.fieldId());
            return this.bucket(sourceColumn, numBuckets, columnName + "_bucket");
        }

        public Builder truncate(String sourceName, int width, String targetName) {
            return this.truncate(this.findSourceColumn(sourceName), width, targetName);
        }

        private Builder truncate(Types.NestedField sourceColumn, int width, String targetName) {
            this.checkAndAddPartitionName(targetName);
            this.fields.add(new PartitionField(sourceColumn.fieldId(), this.nextFieldId(), targetName, Transforms.truncate(width)));
            return this;
        }

        public Builder truncate(String sourceName, int width) {
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            String columnName = this.schema.findColumnName(sourceColumn.fieldId());
            return this.truncate(sourceColumn, width, columnName + "_trunc");
        }

        public Builder alwaysNull(String sourceName, String targetName) {
            return this.alwaysNull(this.findSourceColumn(sourceName), targetName);
        }

        private Builder alwaysNull(Types.NestedField sourceColumn, String targetName) {
            this.checkAndAddPartitionName(targetName, sourceColumn.fieldId());
            this.fields.add(new PartitionField(sourceColumn.fieldId(), this.nextFieldId(), targetName, Transforms.alwaysNull()));
            return this;
        }

        public Builder alwaysNull(String sourceName) {
            Types.NestedField sourceColumn = this.findSourceColumn(sourceName);
            String columnName = this.schema.findColumnName(sourceColumn.fieldId());
            return this.alwaysNull(sourceColumn, columnName + "_null");
        }

        Builder add(int sourceId, String name, Transform<?, ?> transform) {
            return this.add(sourceId, this.nextFieldId(), name, transform);
        }

        Builder add(int sourceId, int fieldId, String name, Transform<?, ?> transform) {
            this.checkAndAddPartitionName(name, sourceId);
            this.fields.add(new PartitionField(sourceId, fieldId, name, transform));
            this.lastAssignedFieldId.getAndAccumulate(fieldId, Math::max);
            return this;
        }

        public PartitionSpec build() {
            PartitionSpec spec = this.buildUnchecked();
            PartitionSpec.checkCompatibility(spec, this.schema);
            return spec;
        }

        PartitionSpec buildUnchecked() {
            return new PartitionSpec(this.schema, this.specId, this.fields, this.lastAssignedFieldId.get());
        }
    }
}

