/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Updates to apply to a Principal")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UpdatePrincipalRequest {
    @NotNull
    private final Integer currentEntityVersion;
    @NotNull
    private final Map<String, String> properties;

    @ApiModelProperty(required=true, value="The version of the object onto which this update is applied; if the object changed, the update will fail and the caller should retry after fetching the latest version.")
    @JsonProperty(value="currentEntityVersion", required=true)
    public Integer getCurrentEntityVersion() {
        return this.currentEntityVersion;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="properties", required=true)
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonCreator
    public UpdatePrincipalRequest(@JsonProperty(value="currentEntityVersion", required=true) Integer currentEntityVersion, @JsonProperty(value="properties", required=true) Map<String, String> properties) {
        this.currentEntityVersion = currentEntityVersion;
        this.properties = Objects.requireNonNullElse(properties, new HashMap());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Integer currentEntityVersion, Map<String, String> properties) {
        return new Builder(currentEntityVersion, properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdatePrincipalRequest updatePrincipalRequest = (UpdatePrincipalRequest)o;
        return Objects.equals(this.currentEntityVersion, updatePrincipalRequest.currentEntityVersion) && Objects.equals(this.properties, updatePrincipalRequest.properties);
    }

    public int hashCode() {
        return Objects.hash(this.currentEntityVersion, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdatePrincipalRequest {\n");
        sb.append("    currentEntityVersion: ").append(this.toIndentedString(this.currentEntityVersion)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private Integer currentEntityVersion;
        private Map<String, String> properties;

        private Builder() {
        }

        private Builder(Integer currentEntityVersion, Map<String, String> properties) {
            this.currentEntityVersion = currentEntityVersion;
            this.properties = Objects.requireNonNullElse(properties, new HashMap());
        }

        public Builder setCurrentEntityVersion(Integer currentEntityVersion) {
            this.currentEntityVersion = currentEntityVersion;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public UpdatePrincipalRequest build() {
            UpdatePrincipalRequest inst = new UpdatePrincipalRequest(this.currentEntityVersion, this.properties);
            return inst;
        }
    }
}

