/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.cache;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.polaris.core.storage.cache.StorageCredentialCacheKey;
import org.immutables.value.Generated;

@Generated(from="StorageCredentialCacheKey", generator="Immutables")
public final class ImmutableStorageCredentialCacheKey
implements StorageCredentialCacheKey {
    private final String realmId;
    private final long catalogId;
    @Nullable
    private final String storageConfigSerializedStr;
    private final boolean allowedListAction;
    private final ImmutableSet<String> allowedReadLocations;
    private final ImmutableSet<String> allowedWriteLocations;
    private final String refreshCredentialsEndpoint;
    private transient int hashCode;

    private ImmutableStorageCredentialCacheKey(String realmId, long catalogId, @Nullable String storageConfigSerializedStr, boolean allowedListAction, Iterable<String> allowedReadLocations, Iterable<String> allowedWriteLocations, Optional<String> refreshCredentialsEndpoint) {
        this.realmId = Objects.requireNonNull(realmId, "realmId");
        this.catalogId = catalogId;
        this.storageConfigSerializedStr = storageConfigSerializedStr;
        this.allowedListAction = allowedListAction;
        this.allowedReadLocations = ImmutableSet.copyOf(allowedReadLocations);
        this.allowedWriteLocations = ImmutableSet.copyOf(allowedWriteLocations);
        this.refreshCredentialsEndpoint = refreshCredentialsEndpoint.orElse(null);
    }

    private ImmutableStorageCredentialCacheKey(ImmutableStorageCredentialCacheKey original, String realmId, long catalogId, @Nullable String storageConfigSerializedStr, boolean allowedListAction, ImmutableSet<String> allowedReadLocations, ImmutableSet<String> allowedWriteLocations, String refreshCredentialsEndpoint) {
        this.realmId = realmId;
        this.catalogId = catalogId;
        this.storageConfigSerializedStr = storageConfigSerializedStr;
        this.allowedListAction = allowedListAction;
        this.allowedReadLocations = allowedReadLocations;
        this.allowedWriteLocations = allowedWriteLocations;
        this.refreshCredentialsEndpoint = refreshCredentialsEndpoint;
    }

    @Override
    public String realmId() {
        return this.realmId;
    }

    @Override
    public long catalogId() {
        return this.catalogId;
    }

    @Override
    @Nullable
    public String storageConfigSerializedStr() {
        return this.storageConfigSerializedStr;
    }

    @Override
    public boolean allowedListAction() {
        return this.allowedListAction;
    }

    public ImmutableSet<String> allowedReadLocations() {
        return this.allowedReadLocations;
    }

    public ImmutableSet<String> allowedWriteLocations() {
        return this.allowedWriteLocations;
    }

    @Override
    public Optional<String> refreshCredentialsEndpoint() {
        return Optional.ofNullable(this.refreshCredentialsEndpoint);
    }

    public final ImmutableStorageCredentialCacheKey withRealmId(String value) {
        String newValue = Objects.requireNonNull(value, "realmId");
        if (this.realmId.equals(newValue)) {
            return this;
        }
        return new ImmutableStorageCredentialCacheKey(this, newValue, this.catalogId, this.storageConfigSerializedStr, this.allowedListAction, this.allowedReadLocations, this.allowedWriteLocations, this.refreshCredentialsEndpoint);
    }

    public final ImmutableStorageCredentialCacheKey withCatalogId(long value) {
        if (this.catalogId == value) {
            return this;
        }
        return new ImmutableStorageCredentialCacheKey(this, this.realmId, value, this.storageConfigSerializedStr, this.allowedListAction, this.allowedReadLocations, this.allowedWriteLocations, this.refreshCredentialsEndpoint);
    }

    public final ImmutableStorageCredentialCacheKey withStorageConfigSerializedStr(@Nullable String value) {
        if (Objects.equals(this.storageConfigSerializedStr, value)) {
            return this;
        }
        return new ImmutableStorageCredentialCacheKey(this, this.realmId, this.catalogId, value, this.allowedListAction, this.allowedReadLocations, this.allowedWriteLocations, this.refreshCredentialsEndpoint);
    }

    public final ImmutableStorageCredentialCacheKey withAllowedListAction(boolean value) {
        if (this.allowedListAction == value) {
            return this;
        }
        return new ImmutableStorageCredentialCacheKey(this, this.realmId, this.catalogId, this.storageConfigSerializedStr, value, this.allowedReadLocations, this.allowedWriteLocations, this.refreshCredentialsEndpoint);
    }

    public final ImmutableStorageCredentialCacheKey withAllowedReadLocations(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableStorageCredentialCacheKey(this, this.realmId, this.catalogId, this.storageConfigSerializedStr, this.allowedListAction, (ImmutableSet<String>)newValue, this.allowedWriteLocations, this.refreshCredentialsEndpoint);
    }

    public final ImmutableStorageCredentialCacheKey withAllowedReadLocations(Iterable<String> elements) {
        if (this.allowedReadLocations == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableStorageCredentialCacheKey(this, this.realmId, this.catalogId, this.storageConfigSerializedStr, this.allowedListAction, (ImmutableSet<String>)newValue, this.allowedWriteLocations, this.refreshCredentialsEndpoint);
    }

    public final ImmutableStorageCredentialCacheKey withAllowedWriteLocations(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableStorageCredentialCacheKey(this, this.realmId, this.catalogId, this.storageConfigSerializedStr, this.allowedListAction, this.allowedReadLocations, (ImmutableSet<String>)newValue, this.refreshCredentialsEndpoint);
    }

    public final ImmutableStorageCredentialCacheKey withAllowedWriteLocations(Iterable<String> elements) {
        if (this.allowedWriteLocations == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableStorageCredentialCacheKey(this, this.realmId, this.catalogId, this.storageConfigSerializedStr, this.allowedListAction, this.allowedReadLocations, (ImmutableSet<String>)newValue, this.refreshCredentialsEndpoint);
    }

    public final ImmutableStorageCredentialCacheKey withRefreshCredentialsEndpoint(String value) {
        String newValue = Objects.requireNonNull(value, "refreshCredentialsEndpoint");
        if (Objects.equals(this.refreshCredentialsEndpoint, newValue)) {
            return this;
        }
        return new ImmutableStorageCredentialCacheKey(this, this.realmId, this.catalogId, this.storageConfigSerializedStr, this.allowedListAction, this.allowedReadLocations, this.allowedWriteLocations, newValue);
    }

    public final ImmutableStorageCredentialCacheKey withRefreshCredentialsEndpoint(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.refreshCredentialsEndpoint, value)) {
            return this;
        }
        return new ImmutableStorageCredentialCacheKey(this, this.realmId, this.catalogId, this.storageConfigSerializedStr, this.allowedListAction, this.allowedReadLocations, this.allowedWriteLocations, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStorageCredentialCacheKey && this.equalsByValue((ImmutableStorageCredentialCacheKey)another);
    }

    private boolean equalsByValue(ImmutableStorageCredentialCacheKey another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.realmId.equals(another.realmId) && this.catalogId == another.catalogId && Objects.equals(this.storageConfigSerializedStr, another.storageConfigSerializedStr) && this.allowedListAction == another.allowedListAction && this.allowedReadLocations.equals(another.allowedReadLocations) && this.allowedWriteLocations.equals(another.allowedWriteLocations) && Objects.equals(this.refreshCredentialsEndpoint, another.refreshCredentialsEndpoint);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.realmId.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.catalogId);
        h += (h << 5) + Objects.hashCode(this.storageConfigSerializedStr);
        h += (h << 5) + Booleans.hashCode((boolean)this.allowedListAction);
        h += (h << 5) + this.allowedReadLocations.hashCode();
        h += (h << 5) + this.allowedWriteLocations.hashCode();
        h += (h << 5) + Objects.hashCode(this.refreshCredentialsEndpoint);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StorageCredentialCacheKey").omitNullValues().add("realmId", (Object)this.realmId).add("catalogId", this.catalogId).add("storageConfigSerializedStr", (Object)this.storageConfigSerializedStr).add("allowedListAction", this.allowedListAction).add("allowedReadLocations", this.allowedReadLocations).add("allowedWriteLocations", this.allowedWriteLocations).add("refreshCredentialsEndpoint", (Object)this.refreshCredentialsEndpoint).toString();
    }

    public static ImmutableStorageCredentialCacheKey of(String realmId, long catalogId, @Nullable String storageConfigSerializedStr, boolean allowedListAction, Set<String> allowedReadLocations, Set<String> allowedWriteLocations, Optional<String> refreshCredentialsEndpoint) {
        return ImmutableStorageCredentialCacheKey.of(realmId, catalogId, storageConfigSerializedStr, allowedListAction, allowedReadLocations, allowedWriteLocations, refreshCredentialsEndpoint);
    }

    public static ImmutableStorageCredentialCacheKey of(String realmId, long catalogId, @Nullable String storageConfigSerializedStr, boolean allowedListAction, Iterable<String> allowedReadLocations, Iterable<String> allowedWriteLocations, Optional<String> refreshCredentialsEndpoint) {
        return new ImmutableStorageCredentialCacheKey(realmId, catalogId, storageConfigSerializedStr, allowedListAction, allowedReadLocations, allowedWriteLocations, refreshCredentialsEndpoint);
    }

    public static ImmutableStorageCredentialCacheKey copyOf(StorageCredentialCacheKey instance) {
        if (instance instanceof ImmutableStorageCredentialCacheKey) {
            return (ImmutableStorageCredentialCacheKey)instance;
        }
        return ImmutableStorageCredentialCacheKey.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableStorageCredentialCacheKey.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StorageCredentialCacheKey", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_REALM_ID = 1L;
        private static final long INIT_BIT_CATALOG_ID = 2L;
        private static final long INIT_BIT_ALLOWED_LIST_ACTION = 4L;
        private long initBits = 7L;
        private String realmId;
        private long catalogId;
        private String storageConfigSerializedStr;
        private boolean allowedListAction;
        private ImmutableSet.Builder<String> allowedReadLocations = ImmutableSet.builder();
        private ImmutableSet.Builder<String> allowedWriteLocations = ImmutableSet.builder();
        private String refreshCredentialsEndpoint;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StorageCredentialCacheKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.realmId(instance.realmId());
            this.catalogId(instance.catalogId());
            String storageConfigSerializedStrValue = instance.storageConfigSerializedStr();
            if (storageConfigSerializedStrValue != null) {
                this.storageConfigSerializedStr(storageConfigSerializedStrValue);
            }
            this.allowedListAction(instance.allowedListAction());
            this.addAllAllowedReadLocations(instance.allowedReadLocations());
            this.addAllAllowedWriteLocations(instance.allowedWriteLocations());
            Optional<String> refreshCredentialsEndpointOptional = instance.refreshCredentialsEndpoint();
            if (refreshCredentialsEndpointOptional.isPresent()) {
                this.refreshCredentialsEndpoint(refreshCredentialsEndpointOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder realmId(String realmId) {
            this.realmId = Objects.requireNonNull(realmId, "realmId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder catalogId(long catalogId) {
            this.catalogId = catalogId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder storageConfigSerializedStr(@Nullable String storageConfigSerializedStr) {
            this.storageConfigSerializedStr = storageConfigSerializedStr;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allowedListAction(boolean allowedListAction) {
            this.allowedListAction = allowedListAction;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllowedReadLocation(String element) {
            this.allowedReadLocations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllowedReadLocations(String ... elements) {
            this.allowedReadLocations.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allowedReadLocations(Iterable<String> elements) {
            this.allowedReadLocations = ImmutableSet.builder();
            return this.addAllAllowedReadLocations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAllowedReadLocations(Iterable<String> elements) {
            this.allowedReadLocations.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllowedWriteLocation(String element) {
            this.allowedWriteLocations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllowedWriteLocations(String ... elements) {
            this.allowedWriteLocations.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allowedWriteLocations(Iterable<String> elements) {
            this.allowedWriteLocations = ImmutableSet.builder();
            return this.addAllAllowedWriteLocations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAllowedWriteLocations(Iterable<String> elements) {
            this.allowedWriteLocations.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refreshCredentialsEndpoint(String refreshCredentialsEndpoint) {
            this.refreshCredentialsEndpoint = Objects.requireNonNull(refreshCredentialsEndpoint, "refreshCredentialsEndpoint");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refreshCredentialsEndpoint(Optional<String> refreshCredentialsEndpoint) {
            this.refreshCredentialsEndpoint = refreshCredentialsEndpoint.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 7L;
            this.realmId = null;
            this.catalogId = 0L;
            this.storageConfigSerializedStr = null;
            this.allowedListAction = false;
            this.allowedReadLocations = ImmutableSet.builder();
            this.allowedWriteLocations = ImmutableSet.builder();
            this.refreshCredentialsEndpoint = null;
            return this;
        }

        public ImmutableStorageCredentialCacheKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStorageCredentialCacheKey(null, this.realmId, this.catalogId, this.storageConfigSerializedStr, this.allowedListAction, (ImmutableSet<String>)this.allowedReadLocations.build(), (ImmutableSet<String>)this.allowedWriteLocations.build(), this.refreshCredentialsEndpoint);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("realmId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("catalogId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("allowedListAction");
            }
            return "Cannot build StorageCredentialCacheKey, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

