/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.policy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nullable;
import org.apache.polaris.core.policy.PolicyType;

public enum PredefinedPolicyTypes implements PolicyType
{
    DATA_COMPACTION(0, "system.data-compaction", true),
    METADATA_COMPACTION(1, "system.metadata-compaction", true),
    ORPHAN_FILE_REMOVAL(2, "system.orphan-file-removal", true),
    SNAPSHOT_EXPIRY(3, "system.snapshot-expiry", true);

    private final int code;
    private final String name;
    private final boolean isInheritable;
    private static final PredefinedPolicyTypes[] REVERSE_CODE_MAPPING_ARRAY;
    private static final ImmutableMap<String, PredefinedPolicyTypes> REVERSE_NAME_MAPPING_ARRAY;

    private PredefinedPolicyTypes(int code, String name, boolean isInheritable) {
        this.code = code;
        this.name = name;
        this.isInheritable = isInheritable;
    }

    @Override
    @JsonValue
    public int getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isInheritable() {
        return this.isInheritable;
    }

    @JsonCreator
    @Nullable
    public static PredefinedPolicyTypes fromCode(int code) {
        if (code >= REVERSE_CODE_MAPPING_ARRAY.length) {
            return null;
        }
        return REVERSE_CODE_MAPPING_ARRAY[code];
    }

    @Nullable
    public static PredefinedPolicyTypes fromName(String name) {
        return (PredefinedPolicyTypes)REVERSE_NAME_MAPPING_ARRAY.get((Object)name);
    }

    static {
        int maxId = 0;
        for (PredefinedPolicyTypes policyType : PredefinedPolicyTypes.values()) {
            if (maxId >= policyType.code) continue;
            maxId = policyType.code;
        }
        REVERSE_CODE_MAPPING_ARRAY = new PredefinedPolicyTypes[maxId + 1];
        ImmutableMap.Builder builder = ImmutableMap.builder();
        PredefinedPolicyTypes[] predefinedPolicyTypesArray = PredefinedPolicyTypes.values();
        int n = predefinedPolicyTypesArray.length;
        for (int i = 0; i < n; ++i) {
            PredefinedPolicyTypes policyType;
            PredefinedPolicyTypes.REVERSE_CODE_MAPPING_ARRAY[policyType.code] = policyType = predefinedPolicyTypesArray[i];
            builder.put((Object)policyType.name, (Object)policyType);
        }
        REVERSE_NAME_MAPPING_ARRAY = builder.build();
    }
}

