/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.ratelimiter;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Duration;
import java.time.InstantSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.ratelimiter.TokenBucket;
import org.apache.polaris.service.ratelimiter.TokenBucketConfiguration;
import org.apache.polaris.service.ratelimiter.TokenBucketFactory;

@ApplicationScoped
@Identifier(value="default")
public class DefaultTokenBucketFactory
implements TokenBucketFactory {
    private final long requestsPerSecond;
    private final Duration window;
    private final Clock clock;
    private final Map<String, TokenBucket> perRealmBuckets;

    @Inject
    public DefaultTokenBucketFactory(TokenBucketConfiguration configuration, Clock clock) {
        this(configuration.requestsPerSecond(), configuration.window(), clock);
    }

    public DefaultTokenBucketFactory(long requestsPerSecond, Duration window, Clock clock) {
        this.perRealmBuckets = new ConcurrentHashMap<String, TokenBucket>();
        this.requestsPerSecond = requestsPerSecond;
        this.window = window;
        this.clock = clock;
    }

    public TokenBucket getOrCreateTokenBucket(RealmContext realmContext) {
        String realmId = realmContext.getRealmIdentifier();
        return this.perRealmBuckets.computeIfAbsent(realmId, k -> new TokenBucket(this.requestsPerSecond, Math.multiplyExact(this.requestsPerSecond, this.window.toSeconds()), (InstantSource)this.clock));
    }

    public DefaultTokenBucketFactory() {
    }
}

