/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.context.catalog;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.SecurityContext;
import java.util.HashMap;
import org.apache.iceberg.catalog.Catalog;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifest;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifestCatalogView;
import org.apache.polaris.core.persistence.resolver.ResolverFactory;
import org.apache.polaris.core.storage.cache.StorageCredentialCache;
import org.apache.polaris.service.catalog.iceberg.IcebergCatalog;
import org.apache.polaris.service.catalog.io.FileIOFactory;
import org.apache.polaris.service.context.catalog.CallContextCatalogFactory;
import org.apache.polaris.service.events.PolarisEventListener;
import org.apache.polaris.service.task.TaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PolarisCallContextCatalogFactory
implements CallContextCatalogFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisCallContextCatalogFactory.class);
    private final TaskExecutor taskExecutor;
    private final FileIOFactory fileIOFactory;
    private final StorageCredentialCache storageCredentialCache;
    private final ResolverFactory resolverFactory;
    private final MetaStoreManagerFactory metaStoreManagerFactory;
    private final PolarisEventListener polarisEventListener;

    @Inject
    public PolarisCallContextCatalogFactory(StorageCredentialCache storageCredentialCache, ResolverFactory resolverFactory, MetaStoreManagerFactory metaStoreManagerFactory, TaskExecutor taskExecutor, FileIOFactory fileIOFactory, PolarisEventListener polarisEventListener) {
        this.storageCredentialCache = storageCredentialCache;
        this.resolverFactory = resolverFactory;
        this.metaStoreManagerFactory = metaStoreManagerFactory;
        this.taskExecutor = taskExecutor;
        this.fileIOFactory = fileIOFactory;
        this.polarisEventListener = polarisEventListener;
    }

    public Catalog createCallContextCatalog(CallContext context, PolarisPrincipal polarisPrincipal, SecurityContext securityContext, PolarisResolutionManifest resolvedManifest) {
        PolarisEntity baseCatalogEntity = resolvedManifest.getResolvedReferenceCatalogEntity().getRawLeafEntity();
        String catalogName = baseCatalogEntity.getName();
        String realm = context.getRealmContext().getRealmIdentifier();
        String catalogKey = realm + "/" + catalogName;
        LOGGER.debug("Initializing new BasePolarisCatalog for key: {}", (Object)catalogKey);
        IcebergCatalog catalogInstance = new IcebergCatalog(this.storageCredentialCache, this.resolverFactory, this.metaStoreManagerFactory.getOrCreateMetaStoreManager(context.getRealmContext()), context, (PolarisResolutionManifestCatalogView)resolvedManifest, securityContext, this.taskExecutor, this.fileIOFactory, this.polarisEventListener);
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)baseCatalogEntity);
        HashMap<String, String> catalogProperties = new HashMap<String, String>(catalog.getPropertiesAsMap());
        String defaultBaseLocation = catalog.getBaseLocation();
        LOGGER.debug("Looked up defaultBaseLocation {} for catalog {}", (Object)defaultBaseLocation, (Object)catalogKey);
        if (defaultBaseLocation == null) {
            throw new IllegalStateException(String.format("Catalog '%s' does not have a configured warehouse location. Please configure a default base location for this catalog.", catalogKey));
        }
        catalogProperties.put("warehouse", defaultBaseLocation);
        catalogInstance.initialize(catalogName, catalogProperties);
        return catalogInstance;
    }

    public PolarisCallContextCatalogFactory() {
    }
}

