/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.generic;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.polaris.core.catalog.GenericTableCatalog;
import org.apache.polaris.core.catalog.PolarisCatalogHelpers;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.table.GenericTableEntity;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.dao.entity.DropEntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifestCatalogView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisGenericTableCatalog
implements GenericTableCatalog {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisGenericTableCatalog.class);
    private String name;
    private final CallContext callContext;
    private final PolarisResolutionManifestCatalogView resolvedEntityView;
    private final CatalogEntity catalogEntity;
    private long catalogId = -1L;
    private PolarisMetaStoreManager metaStoreManager;

    public PolarisGenericTableCatalog(PolarisMetaStoreManager metaStoreManager, CallContext callContext, PolarisResolutionManifestCatalogView resolvedEntityView) {
        this.callContext = callContext;
        this.resolvedEntityView = resolvedEntityView;
        this.catalogEntity = CatalogEntity.of((PolarisBaseEntity)resolvedEntityView.getResolvedReferenceCatalogEntity().getRawLeafEntity());
        this.catalogId = this.catalogEntity.getId();
        this.metaStoreManager = metaStoreManager;
    }

    public void initialize(String name, Map<String, String> properties) {
        this.name = name;
        if (!properties.isEmpty()) {
            throw new IllegalStateException("PolarisGenericTableCatalog does not support properties");
        }
    }

    public GenericTableEntity createGenericTable(TableIdentifier tableIdentifier, String format, String baseLocation, String doc, Map<String, String> properties) {
        PolarisResolvedPathWrapper resolvedParent = this.resolvedEntityView.getResolvedPath((Object)tableIdentifier.namespace());
        if (resolvedParent == null) {
            throw new IllegalStateException(String.format("Failed to fetch resolved parent for TableIdentifier '%s'", tableIdentifier));
        }
        List catalogPath = resolvedParent.getRawFullPath();
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getPassthroughResolvedPath((Object)tableIdentifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ANY_SUBTYPE);
        GenericTableEntity entity = GenericTableEntity.of((PolarisBaseEntity)(resolvedEntities == null ? null : resolvedEntities.getRawLeafEntity()));
        if (null != entity) {
            throw new AlreadyExistsException("Iceberg table, view, or generic table already exists: %s", new Object[]{tableIdentifier});
        }
        entity = ((GenericTableEntity.Builder)((GenericTableEntity.Builder)((GenericTableEntity.Builder)((GenericTableEntity.Builder)((GenericTableEntity.Builder)new GenericTableEntity.Builder(tableIdentifier, format).setCatalogId(this.catalogId)).setParentNamespace(tableIdentifier.namespace()).setParentId(resolvedParent.getRawLeafEntity().getId())).setId(this.metaStoreManager.generateNewEntityId(this.callContext.getPolarisCallContext()).getId().longValue())).setProperties(properties)).setDoc(doc).setBaseLocation(baseLocation).setCreateTimestamp(System.currentTimeMillis())).build();
        EntityResult res = this.metaStoreManager.createEntityIfNotExists(this.callContext.getPolarisCallContext(), PolarisEntity.toCoreList((List)catalogPath), (PolarisBaseEntity)entity);
        if (!res.isSuccess()) {
            switch (res.getReturnStatus()) {
                case ENTITY_ALREADY_EXISTS: {
                    throw new AlreadyExistsException("Iceberg table, view, or generic table already exists: %s", new Object[]{tableIdentifier});
                }
            }
            throw new IllegalStateException(String.format("Unknown error status for identifier %s: %s with extraInfo: %s", tableIdentifier, res.getReturnStatus(), res.getExtraInformation()));
        }
        GenericTableEntity resultEntity = GenericTableEntity.of((PolarisBaseEntity)res.getEntity());
        LOGGER.debug("Created GenericTable entity {} with TableIdentifier {}", (Object)resultEntity, (Object)tableIdentifier);
        return resultEntity;
    }

    public GenericTableEntity loadGenericTable(TableIdentifier tableIdentifier) {
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getPassthroughResolvedPath((Object)tableIdentifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.GENERIC_TABLE);
        GenericTableEntity entity = GenericTableEntity.of((PolarisBaseEntity)(resolvedEntities == null ? null : resolvedEntities.getRawLeafEntity()));
        if (null == entity) {
            throw new NoSuchTableException("Generic table does not exist: %s", new Object[]{tableIdentifier});
        }
        return entity;
    }

    public boolean dropGenericTable(TableIdentifier tableIdentifier) {
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getPassthroughResolvedPath((Object)tableIdentifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.GENERIC_TABLE);
        if (resolvedEntities == null) {
            throw new NoSuchTableException("Generic table does not exist: %s", new Object[]{tableIdentifier});
        }
        List catalogPath = resolvedEntities.getRawParentPath();
        PolarisEntity leafEntity = resolvedEntities.getRawLeafEntity();
        DropEntityResult dropEntityResult = this.metaStoreManager.dropEntityIfExists(this.callContext.getPolarisCallContext(), PolarisEntity.toCoreList((List)catalogPath), (PolarisBaseEntity)leafEntity, Map.of(), false);
        return dropEntityResult.isSuccess();
    }

    public List<TableIdentifier> listGenericTables(Namespace namespace) {
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getResolvedPath((Object)namespace);
        if (resolvedEntities == null) {
            throw new NoSuchNamespaceException("Namespace '%s' does not exist", new Object[]{namespace});
        }
        List catalogPath = resolvedEntities.getRawFullPath();
        List entities = PolarisEntity.toNameAndIdList((List)this.metaStoreManager.listEntities(this.callContext.getPolarisCallContext(), PolarisEntity.toCoreList((List)catalogPath), PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.GENERIC_TABLE, PageToken.readEverything()).getEntities());
        return PolarisCatalogHelpers.nameAndIdToTableIdentifiers((List)catalogPath, (List)entities);
    }
}

