/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.observability;

import io.quarkus.resteasy.reactive.server.runtime.observability.ObservabilityUtil;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.AuthenticationException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.util.PathHelper;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.handlers.ClassRoutingHandler;
import org.jboss.resteasy.reactive.server.handlers.RestInitialHandler;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

@Recorder
public class ObservabilityIntegrationRecorder {
    private static final Logger log = Logger.getLogger(ObservabilityIntegrationRecorder.class);

    public Handler<RoutingContext> preAuthFailureHandler(final RuntimeValue<Deployment> deploymentRV) {
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                if (this.shouldHandle(event)) {
                    try {
                        ObservabilityIntegrationRecorder.setTemplatePath(event, (Deployment)deploymentRV.getValue());
                    }
                    catch (Exception e) {
                        log.debug((Object)"Unable to set template path for observability", (Throwable)e);
                    }
                }
                event.next();
            }

            private boolean shouldHandle(RoutingContext event) {
                if (!event.failed()) {
                    return false;
                }
                return event.failure() instanceof AuthenticationException || event.failure() instanceof ForbiddenException || event.failure() instanceof UnauthorizedException;
            }
        };
    }

    public static void setTemplatePath(RoutingContext rc, Deployment deployment) {
        Object templatePath;
        RequestMapper.RequestMatch target;
        String requestMethod;
        RequestMapper initMappers = new RequestMapper(deployment.getClassMappers());
        RequestMapper.RequestMatch requestMatch = initMappers.map(ObservabilityIntegrationRecorder.getPathWithoutPrefix(rc, deployment));
        if (requestMatch == null) {
            return;
        }
        String remaining = requestMatch.remaining.isEmpty() ? "/" : requestMatch.remaining;
        ServerRestHandler[] serverRestHandlers = ((RestInitialHandler.InitialMatch)requestMatch.value).handlers;
        if (serverRestHandlers == null || serverRestHandlers.length < 1) {
            return;
        }
        ServerRestHandler firstHandler = serverRestHandlers[0];
        if (!(firstHandler instanceof ClassRoutingHandler)) {
            return;
        }
        ClassRoutingHandler classRoutingHandler = (ClassRoutingHandler)firstHandler;
        Map mappers = classRoutingHandler.getMappers();
        RequestMapper mapper = (RequestMapper)mappers.get(requestMethod = rc.request().method().name());
        if (mapper == null) {
            if (requestMethod.equals("HEAD") || requestMethod.equals("OPTIONS")) {
                mapper = (RequestMapper)mappers.get("GET");
            }
            if (mapper == null) {
                mapper = (RequestMapper)mappers.get(null);
            }
            if (mapper == null) {
                return;
            }
        }
        if ((target = mapper.map(remaining)) == null) {
            if (requestMethod.equals("HEAD") && (mapper = (RequestMapper)mappers.get("GET")) != null) {
                target = mapper.map(remaining);
            }
            if (target == null) {
                return;
            }
        }
        if (((String)(templatePath = requestMatch.template.template + target.template.template)).endsWith("/")) {
            templatePath = ((String)templatePath).substring(0, ((String)templatePath).length() - 1);
        }
        ObservabilityUtil.setUrlPathTemplate(rc, (String)templatePath);
    }

    private static String getPathWithoutPrefix(RoutingContext rc, Deployment deployment) {
        return PathHelper.getPathWithoutPrefix((String)rc.normalizedPath(), (String)deployment.getPrefix());
    }
}

