/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.InternalData;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.V1Metadata;
import org.apache.iceberg.V2Metadata;
import org.apache.iceberg.V3Metadata;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

abstract class ManifestListWriter
implements FileAppender<ManifestFile> {
    private final FileAppender<ManifestFile> writer;

    private ManifestListWriter(OutputFile file, Map<String, String> meta) {
        this.writer = this.newAppender(file, meta);
    }

    protected abstract ManifestFile prepare(ManifestFile var1);

    protected abstract FileAppender<ManifestFile> newAppender(OutputFile var1, Map<String, String> var2);

    public void add(ManifestFile manifest) {
        this.writer.add((Object)this.prepare(manifest));
    }

    public void addAll(Iterator<ManifestFile> values) {
        values.forEachRemaining(this::add);
    }

    public void addAll(Iterable<ManifestFile> values) {
        values.forEach(this::add);
    }

    public Metrics metrics() {
        return this.writer.metrics();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public long length() {
        return this.writer.length();
    }

    public Long nextRowId() {
        return null;
    }

    static class V1Writer
    extends ManifestListWriter {
        private final V1Metadata.ManifestFileWrapper wrapper = new V1Metadata.ManifestFileWrapper();

        V1Writer(OutputFile snapshotFile, long snapshotId, Long parentSnapshotId) {
            super(snapshotFile, (Map<String, String>)ImmutableMap.of((Object)"snapshot-id", (Object)String.valueOf(snapshotId), (Object)"parent-snapshot-id", (Object)String.valueOf(parentSnapshotId), (Object)"format-version", (Object)"1"));
        }

        @Override
        protected ManifestFile prepare(ManifestFile manifest) {
            Preconditions.checkArgument((manifest.content() == ManifestContent.DATA ? 1 : 0) != 0, (Object)"Cannot store delete manifests in a v1 table");
            return this.wrapper.wrap(manifest);
        }

        @Override
        protected FileAppender<ManifestFile> newAppender(OutputFile file, Map<String, String> meta) {
            try {
                return InternalData.write(FileFormat.AVRO, file).schema(V1Metadata.MANIFEST_LIST_SCHEMA).named("manifest_file").meta(meta).overwrite().build();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create snapshot list writer for path: %s", new Object[]{file.location()});
            }
        }
    }

    static class V2Writer
    extends ManifestListWriter {
        private final V2Metadata.ManifestFileWrapper wrapper;

        V2Writer(OutputFile snapshotFile, long snapshotId, Long parentSnapshotId, long sequenceNumber) {
            super(snapshotFile, (Map<String, String>)ImmutableMap.of((Object)"snapshot-id", (Object)String.valueOf(snapshotId), (Object)"parent-snapshot-id", (Object)String.valueOf(parentSnapshotId), (Object)"sequence-number", (Object)String.valueOf(sequenceNumber), (Object)"format-version", (Object)"2"));
            this.wrapper = new V2Metadata.ManifestFileWrapper(snapshotId, sequenceNumber);
        }

        @Override
        protected ManifestFile prepare(ManifestFile manifest) {
            return this.wrapper.wrap(manifest);
        }

        @Override
        protected FileAppender<ManifestFile> newAppender(OutputFile file, Map<String, String> meta) {
            try {
                return InternalData.write(FileFormat.AVRO, file).schema(V2Metadata.MANIFEST_LIST_SCHEMA).named("manifest_file").meta(meta).overwrite().build();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create snapshot list writer for path: %s", new Object[]{file.location()});
            }
        }
    }

    static class V3Writer
    extends ManifestListWriter {
        private final V3Metadata.ManifestFileWrapper wrapper;
        private Long nextRowId;

        V3Writer(OutputFile snapshotFile, long snapshotId, Long parentSnapshotId, long sequenceNumber, long firstRowId) {
            super(snapshotFile, (Map<String, String>)ImmutableMap.of((Object)"snapshot-id", (Object)String.valueOf(snapshotId), (Object)"parent-snapshot-id", (Object)String.valueOf(parentSnapshotId), (Object)"sequence-number", (Object)String.valueOf(sequenceNumber), (Object)"first-row-id", (Object)String.valueOf(firstRowId), (Object)"format-version", (Object)"3"));
            this.wrapper = new V3Metadata.ManifestFileWrapper(snapshotId, sequenceNumber);
            this.nextRowId = firstRowId;
        }

        @Override
        protected ManifestFile prepare(ManifestFile manifest) {
            if (manifest.content() != ManifestContent.DATA || manifest.firstRowId() != null) {
                return this.wrapper.wrap(manifest, null);
            }
            this.wrapper.wrap(manifest, this.nextRowId);
            this.nextRowId = this.nextRowId + (manifest.existingRowsCount() + manifest.addedRowsCount());
            return this.wrapper;
        }

        @Override
        protected FileAppender<ManifestFile> newAppender(OutputFile file, Map<String, String> meta) {
            try {
                return InternalData.write(FileFormat.AVRO, file).schema(V3Metadata.MANIFEST_LIST_SCHEMA).named("manifest_file").meta(meta).overwrite().build();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create snapshot list writer for path: %s", new Object[]{file.location()});
            }
        }

        @Override
        public Long nextRowId() {
            return this.nextRowId;
        }
    }
}

