/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.azure;

import jakarta.annotation.Nonnull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.polaris.core.storage.StorageLocation;

public class AzureLocation
extends StorageLocation {
    private static final Pattern URI_PATTERN = Pattern.compile("^(abfss?|wasbs?)://([^/?#]+)(.*)?$");
    public static final String ADLS_ENDPOINT = "dfs.core.windows.net";
    public static final String BLOB_ENDPOINT = "blob.core.windows.net";
    private final String scheme;
    private final String storageAccount;
    private final String container;
    private final String endpoint;
    private final String filePath;

    public AzureLocation(@Nonnull String location) {
        super(location);
        Matcher matcher = URI_PATTERN.matcher(location);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid azure location uri " + location);
        }
        this.scheme = matcher.group(1);
        String authority = matcher.group(2);
        String[] parts = authority.split("@", -1);
        if (parts.length != 2) {
            throw new IllegalArgumentException("container and account name must be both provided");
        }
        this.container = parts[0];
        String accountHost = parts[1];
        String[] hostParts = accountHost.split("\\.", 2);
        if (hostParts.length != 2) {
            throw new IllegalArgumentException("storage account and endpoint must be both provided");
        }
        this.storageAccount = hostParts[0];
        this.endpoint = hostParts[1];
        String path = matcher.group(3);
        this.filePath = path == null ? "" : (path.startsWith("/") ? path.substring(1) : path);
    }

    public String getStorageAccount() {
        return this.storageAccount;
    }

    public String getContainer() {
        return this.container;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getScheme() {
        return this.scheme;
    }

    @Override
    public boolean isChildOf(@Nonnull StorageLocation potentialParent) {
        if (potentialParent instanceof AzureLocation) {
            AzureLocation potentialAzureParent = (AzureLocation)potentialParent;
            if (this.container.equals(potentialAzureParent.container) && this.storageAccount.equals(potentialAzureParent.storageAccount)) {
                String formattedFilePath = AzureLocation.ensureLeadingSlash(AzureLocation.ensureTrailingSlash(this.filePath));
                String formattedParentFilePath = AzureLocation.ensureLeadingSlash(AzureLocation.ensureTrailingSlash(potentialAzureParent.filePath));
                return formattedFilePath.startsWith(formattedParentFilePath);
            }
        }
        return false;
    }

    public static boolean isAzureLocation(String location) {
        if (location == null) {
            return false;
        }
        Matcher matcher = URI_PATTERN.matcher(location);
        return matcher.matches();
    }
}

