/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.pagination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.polaris.core.persistence.pagination.EntityIdToken;
import org.immutables.value.Generated;

@Generated(from="EntityIdToken", generator="Immutables")
public final class ImmutableEntityIdToken
implements EntityIdToken {
    private final long entityId;
    private transient int hashCode;

    private ImmutableEntityIdToken(long entityId) {
        this.entityId = entityId;
    }

    @Override
    @JsonProperty(value="i")
    public long entityId() {
        return this.entityId;
    }

    public final ImmutableEntityIdToken withEntityId(long value) {
        if (this.entityId == value) {
            return this;
        }
        return new ImmutableEntityIdToken(value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntityIdToken && this.equalsByValue((ImmutableEntityIdToken)another);
    }

    private boolean equalsByValue(ImmutableEntityIdToken another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.entityId == another.entityId;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.entityId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EntityIdToken").omitNullValues().add("entityId", this.entityId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEntityIdToken fromJson(Json json) {
        Builder builder = ImmutableEntityIdToken.builder();
        if (json.entityIdIsSet) {
            builder.entityId(json._entityId);
        }
        return builder.build();
    }

    public static ImmutableEntityIdToken copyOf(EntityIdToken instance) {
        if (instance instanceof ImmutableEntityIdToken) {
            return (ImmutableEntityIdToken)instance;
        }
        return ImmutableEntityIdToken.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableEntityIdToken.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EntityIdToken", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ENTITY_ID = 1L;
        private long initBits = 1L;
        private long entityId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(EntityIdToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.entityId(instance.entityId());
            return this;
        }

        @JsonProperty(value="i")
        @CanIgnoreReturnValue
        public final Builder entityId(long entityId) {
            this.entityId = entityId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 1L;
            this.entityId = 0L;
            return this;
        }

        public ImmutableEntityIdToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEntityIdToken(this.entityId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entityId");
            }
            return "Cannot build EntityIdToken, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated(from="EntityIdToken", generator="Immutables")
    static final class Json
    implements EntityIdToken {
        @JsonIgnore
        long _entityId;
        @JsonIgnore
        boolean entityIdIsSet;

        Json() {
        }

        @JsonProperty(value="i")
        public void setEntityId(long entityId) {
            this._entityId = entityId;
            this.entityIdIsSet = true;
        }

        @Override
        public long entityId() {
            throw new UnsupportedOperationException();
        }
    }
}

