/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.polaris.service.types.PolicyIdentifier;

public class ListPoliciesResponse {
    private final String nextPageToken;
    @Valid
    private final @Valid Set<@Valid PolicyIdentifier> identifiers;

    @ApiModelProperty(value="An opaque token that allows clients to make use of pagination for list APIs (e.g. ListTables). Clients may initiate the first paginated request by sending an empty query parameter `pageToken` to the server. Servers that support pagination should identify the `pageToken` parameter and return a `next-page-token` in the response if there are more results available.  After the initial request, the value of `next-page-token` from each response must be used as the `pageToken` parameter value for the next request. The server must return `null` value for the `next-page-token` in the last response. Servers that support pagination must return all results in a single response with the value of `next-page-token` set to `null` if the query parameter `pageToken` is not set in the request. Servers that do not support pagination should ignore the `pageToken` parameter and return all results in a single response. The `next-page-token` must be omitted from the response. Clients must interpret either `null` or missing response value of `next-page-token` as the end of the listing results.")
    @JsonProperty(value="next-page-token")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="identifiers")
    public Set<@Valid PolicyIdentifier> getIdentifiers() {
        return this.identifiers;
    }

    @JsonCreator
    public ListPoliciesResponse(@JsonProperty(value="next-page-token") String nextPageToken, @JsonProperty(value="identifiers") Set<@Valid PolicyIdentifier> identifiers) {
        this.nextPageToken = nextPageToken;
        this.identifiers = Objects.requireNonNullElse(identifiers, new LinkedHashSet());
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListPoliciesResponse listPoliciesResponse = (ListPoliciesResponse)o;
        return Objects.equals(this.nextPageToken, listPoliciesResponse.nextPageToken) && Objects.equals(this.identifiers, listPoliciesResponse.identifiers);
    }

    public int hashCode() {
        return Objects.hash(this.nextPageToken, this.identifiers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListPoliciesResponse {\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("    identifiers: ").append(this.toIndentedString(this.identifiers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String nextPageToken;
        private Set<@Valid PolicyIdentifier> identifiers;

        private Builder() {
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder setIdentifiers(Set<@Valid PolicyIdentifier> identifiers) {
            this.identifiers = identifiers;
            return this;
        }

        public ListPoliciesResponse build() {
            ListPoliciesResponse inst = new ListPoliciesResponse(this.nextPageToken, this.identifiers);
            return inst;
        }
    }
}

