/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.picocli.runtime;

import io.quarkus.picocli.runtime.PicocliCommandLineFactory;
import io.quarkus.picocli.runtime.PicocliConfiguration;
import io.quarkus.picocli.runtime.annotations.TopCommand;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.NamedLiteral;
import java.lang.annotation.Annotation;
import picocli.CommandLine;

@ApplicationScoped
public class DefaultPicocliCommandLineFactory
implements PicocliCommandLineFactory {
    private final Instance<Object> topCommand;
    private final PicocliConfiguration picocliConfiguration;
    private final CommandLine.IFactory picocliFactory;

    public DefaultPicocliCommandLineFactory(@TopCommand Instance<Object> topCommand, PicocliConfiguration picocliConfiguration, CommandLine.IFactory picocliFactory) {
        this.topCommand = topCommand;
        this.picocliConfiguration = picocliConfiguration;
        this.picocliFactory = picocliFactory;
    }

    private Class<?> classForName(String name) {
        try {
            return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public CommandLine create() {
        if (this.picocliConfiguration.topCommand().isPresent()) {
            String topCommandName = (String)this.picocliConfiguration.topCommand().get();
            Instance namedTopCommand = this.topCommand.select(new Annotation[]{NamedLiteral.of((String)topCommandName)});
            if (namedTopCommand.isResolvable()) {
                return new CommandLine(namedTopCommand.get(), this.picocliFactory);
            }
            return new CommandLine(this.classForName(topCommandName), this.picocliFactory);
        }
        return new CommandLine(this.topCommand.get(), this.picocliFactory);
    }

    public DefaultPicocliCommandLineFactory() {
    }
}

