/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroWithPartnerVisitor;
import org.apache.iceberg.avro.InternalReaders;
import org.apache.iceberg.avro.SupportsCustomTypes;
import org.apache.iceberg.avro.SupportsRowPosition;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;

public class InternalReader<T>
implements DatumReader<T>,
SupportsRowPosition,
SupportsCustomTypes {
    private static final int ROOT_ID = -1;
    private final Types.StructType expectedType;
    private final Map<Integer, Class<? extends StructLike>> typeMap = Maps.newHashMap();
    private final Map<Integer, Object> idToConstant = ImmutableMap.of();
    private org.apache.avro.Schema fileSchema = null;
    private ValueReader<T> reader = null;

    public static <D> InternalReader<D> create(Schema schema) {
        return new InternalReader(schema);
    }

    InternalReader(Schema readSchema) {
        this.expectedType = readSchema.asStruct();
    }

    private void initReader() {
        this.reader = (ValueReader)AvroWithPartnerVisitor.visit(Pair.of(-1, this.expectedType), this.fileSchema, new ResolvingReadBuilder(), AccessByID.instance());
    }

    public void setSchema(org.apache.avro.Schema schema) {
        this.fileSchema = schema;
        this.initReader();
    }

    @Override
    public void setCustomTypes(Class<? extends StructLike> rootType, Map<Integer, Class<? extends StructLike>> typesById) {
        this.setRootType(rootType);
        for (Map.Entry<Integer, Class<? extends StructLike>> entry : typesById.entrySet()) {
            this.setCustomType(entry.getKey(), entry.getValue());
        }
    }

    public InternalReader<T> setRootType(Class<? extends StructLike> rootClass) {
        this.typeMap.put(-1, rootClass);
        return this;
    }

    public InternalReader<T> setCustomType(int fieldId, Class<? extends StructLike> structClass) {
        this.typeMap.put(fieldId, structClass);
        return this;
    }

    @Override
    public void setRowPositionSupplier(Supplier<Long> posSupplier) {
        if (this.reader instanceof SupportsRowPosition) {
            ((SupportsRowPosition)((Object)this.reader)).setRowPositionSupplier(posSupplier);
        }
    }

    public T read(T reuse, Decoder decoder) throws IOException {
        return this.reader.read(decoder, reuse);
    }

    private static class AccessByID
    implements AvroWithPartnerVisitor.PartnerAccessors<Pair<Integer, Type>> {
        private static final AccessByID INSTANCE = new AccessByID();

        private AccessByID() {
        }

        public static AccessByID instance() {
            return INSTANCE;
        }

        @Override
        public Pair<Integer, Type> fieldPartner(Pair<Integer, Type> partner, Integer fieldId, String name) {
            Types.NestedField field = partner.second().asStructType().field(fieldId.intValue());
            return field != null ? Pair.of(field.fieldId(), field.type()) : null;
        }

        @Override
        public Pair<Integer, Type> mapKeyPartner(Pair<Integer, Type> partner) {
            Types.MapType map = partner.second().asMapType();
            return Pair.of(map.keyId(), map.keyType());
        }

        @Override
        public Pair<Integer, Type> mapValuePartner(Pair<Integer, Type> partner) {
            Types.MapType map = partner.second().asMapType();
            return Pair.of(map.valueId(), map.valueType());
        }

        @Override
        public Pair<Integer, Type> listElementPartner(Pair<Integer, Type> partner) {
            Types.ListType list = partner.second().asListType();
            return Pair.of(list.elementId(), list.elementType());
        }
    }

    private class ResolvingReadBuilder
    extends AvroWithPartnerVisitor<Pair<Integer, Type>, ValueReader<?>> {
        private ResolvingReadBuilder() {
        }

        @Override
        public ValueReader<?> record(Pair<Integer, Type> partner, org.apache.avro.Schema record, List<ValueReader<?>> fieldResults) {
            if (partner == null) {
                return ValueReaders.skipStruct(fieldResults);
            }
            Types.StructType expected = partner.second().asStructType();
            List<Pair<Integer, ValueReader<?>>> readPlan = ValueReaders.buildReadPlan(expected, record, fieldResults, InternalReader.this.idToConstant);
            return this.structReader(readPlan, partner.first(), expected);
        }

        private ValueReader<?> structReader(List<Pair<Integer, ValueReader<?>>> readPlan, int fieldId, Types.StructType struct) {
            Class<? extends StructLike> structClass = InternalReader.this.typeMap.get(fieldId);
            if (structClass != null) {
                return InternalReaders.struct(struct, structClass, readPlan);
            }
            return InternalReaders.struct(struct, readPlan);
        }

        @Override
        public ValueReader<?> union(Pair<Integer, Type> partner, org.apache.avro.Schema union, List<ValueReader<?>> options) {
            return ValueReaders.union(options);
        }

        @Override
        public ValueReader<?> arrayMap(Pair<Integer, Type> partner, org.apache.avro.Schema map, ValueReader<?> keyReader, ValueReader<?> valueReader) {
            return ValueReaders.arrayMap(keyReader, valueReader);
        }

        @Override
        public ValueReader<?> array(Pair<Integer, Type> partner, org.apache.avro.Schema array, ValueReader<?> elementReader) {
            return ValueReaders.array(elementReader);
        }

        @Override
        public ValueReader<?> map(Pair<Integer, Type> partner, org.apache.avro.Schema map, ValueReader<?> valueReader) {
            return ValueReaders.map(ValueReaders.strings(), valueReader);
        }

        @Override
        public ValueReader<?> variant(Pair<Integer, Type> partner, ValueReader<?> metadataReader, ValueReader<?> valueReader) {
            return ValueReaders.variants();
        }

        @Override
        public ValueReader<?> primitive(Pair<Integer, Type> partner, org.apache.avro.Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return ValueReaders.ints();
                    }
                    case "time-micros": {
                        return ValueReaders.longs();
                    }
                    case "timestamp-millis": {
                        ValueReader<Long> longs = ValueReaders.longs();
                        return (decoder, ignored) -> (Long)longs.read(decoder, null) * 1000L;
                    }
                    case "timestamp-micros": 
                    case "timestamp-nanos": {
                        return ValueReaders.longs();
                    }
                    case "decimal": {
                        return ValueReaders.decimal(ValueReaders.decimalBytesReader(primitive), ((LogicalTypes.Decimal)logicalType).getScale());
                    }
                    case "uuid": {
                        return ValueReaders.uuids();
                    }
                }
                throw new IllegalArgumentException("Unknown logical type: " + String.valueOf(logicalType));
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueReaders.nulls();
                }
                case BOOLEAN: {
                    return ValueReaders.booleans();
                }
                case INT: {
                    if (partner != null && partner.second().typeId() == Type.TypeID.LONG) {
                        return ValueReaders.intsAsLongs();
                    }
                    return ValueReaders.ints();
                }
                case LONG: {
                    return ValueReaders.longs();
                }
                case FLOAT: {
                    if (partner != null && partner.second().typeId() == Type.TypeID.DOUBLE) {
                        return ValueReaders.floatsAsDoubles();
                    }
                    return ValueReaders.floats();
                }
                case DOUBLE: {
                    return ValueReaders.doubles();
                }
                case STRING: {
                    return ValueReaders.strings();
                }
                case FIXED: 
                case BYTES: {
                    return ValueReaders.byteBuffers();
                }
                case ENUM: {
                    return ValueReaders.enums(primitive.getEnumSymbols());
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(primitive));
        }
    }
}

