"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseK8sResourceYamls = parseK8sResourceYamls;
var jsYaml = require("js-yaml");
var common_1 = require("./common");
function parseK8sResourceYamls(yamls) {
    var parsedResources = [];
    yamls.forEach(function (yamlContent) {
        var parsedContent = jsYaml.loadAll(yamlContent);
        parsedContent.forEach(function (parsedYaml) {
            if ((0, common_1.isValidK8sResource)(parsedYaml)) {
                parsedResources.push(parsedYaml);
            }
            else {
                (0, common_1.consoleDebugMessage)("Invalid YAML missing required properties ['kind', 'apiVersion', 'metadata'] -> \n".concat(jsYaml.dump(parsedYaml)));
            }
        });
    });
    return parsedResources;
}
//# sourceMappingURL=parseK8sResourceYamls.js.map