"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.flattenTokenMap = flattenTokenMap;
exports.interpolateK8sResourceYaml = interpolateK8sResourceYaml;
var TEMPLATE = {
    OPEN: "${{",
    CLOSE: "}}",
};
function escapeRegex(regexInput) {
    return regexInput.replace(/[/\-\\^$*+?.()|[\]{}]/g, "\\$&");
}
function flattenTokenMap(obj, parent, res) {
    if (parent === void 0) { parent = undefined; }
    if (res === void 0) { res = {}; }
    for (var key in obj) {
        var propName = parent ? parent + "." + key : key;
        if (typeof obj[key] == "object") {
            flattenTokenMap(obj[key], propName, res);
        }
        else {
            res[propName] = obj[key];
        }
    }
    return res;
}
function trimTokensFromInputText(inputText, flattenedTokens) {
    var _a;
    var regex = new RegExp("".concat(escapeRegex(TEMPLATE.OPEN), "[\\s\\S]*?").concat(escapeRegex(TEMPLATE.CLOSE)), "gm");
    var trimmedInputText = inputText;
    (_a = inputText.match(regex)) === null || _a === void 0 ? void 0 : _a.forEach(function (match) {
        var strippedAndTrimmedTemplateMatch = match.replaceAll(TEMPLATE.OPEN, "").replaceAll(TEMPLATE.CLOSE, "").trim();
        if (Object.keys(flattenedTokens).includes(strippedAndTrimmedTemplateMatch)) {
            trimmedInputText = trimmedInputText.replaceAll(match, "".concat(TEMPLATE.OPEN).concat(strippedAndTrimmedTemplateMatch).concat(TEMPLATE.CLOSE));
        }
    });
    return trimmedInputText;
}
function interpolateK8sResourceYaml(k8sResourceYaml, tokenMap) {
    if (!tokenMap) {
        return k8sResourceYaml;
    }
    var flattenedTokens = flattenTokenMap(tokenMap);
    var trimmedTokensFromInputText = trimTokensFromInputText(k8sResourceYaml, flattenedTokens);
    return Object.entries(flattenedTokens).reduce(function (result, _a) {
        var _b = __read(_a, 2), tokenName = _b[0], tokenValue = _b[1];
        return result.replaceAll("".concat(TEMPLATE.OPEN).concat(tokenName).concat(TEMPLATE.CLOSE), tokenValue);
    }, trimmedTokensFromInputText);
}
//# sourceMappingURL=interpolateK8sResourceYaml.js.map