import { Fragment as _Fragment, jsx as _jsx } from "react/jsx-runtime";
import { DashbuilderWrapper } from "../dashbuilder/DashbuilderWrapper";
import * as React from "react";
export class DashbuilderViewerView {
    constructor(envelopeContext, initArgs) {
        this.envelopeContext = envelopeContext;
        this.initArgs = initArgs;
        this.af_isReact = true;
        this.editorRef = React.createRef();
        this.dashbuilderWrapper = new DashbuilderWrapper(() => {
            envelopeContext.channelApi.requests.getComponentsServerUrl().then((componentServerUrl) => {
                if (componentServerUrl) {
                    this.dashbuilderWrapper.setComponentServerUrl(componentServerUrl);
                }
            });
            envelopeContext.channelApi.notifications.kogitoEditor_ready.send();
        });
    }
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        this.dashbuilderWrapper.setContent(content);
        return Promise.resolve();
    }
    getContent() {
        return Promise.resolve(this.dashbuilderWrapper.getContent());
    }
    getPreview() {
        return this.editorRef.current.getPreview();
    }
    af_componentRoot() {
        return _jsx(_Fragment, {});
    }
    async undo() {
        return this.editorRef.current.undo();
    }
    async redo() {
        return this.editorRef.current.redo();
    }
    async validate() {
        return this.editorRef.current.validate();
    }
    async setTheme(theme) {
        return this.editorRef.current.setTheme(theme);
    }
}
//# sourceMappingURL=DashbuilderViewerView.js.map