import { By, Key } from "selenium-webdriver";
import EditorPage from "../editor/EditorPage";
import GitHubEditorPage from "../github-editor/GitHubEditorPage";
class FullScreenPage extends EditorPage {
    async exitFullScreen() {
        const exitButton = await this.tools.by(FullScreenPage.EXIT_BUTTON_LOCATOR).getElement();
        await exitButton.sendKeys(Key.ENTER);
        return await this.tools.createPage(GitHubEditorPage);
    }
    async waitUntilLoaded() {
        return await this.tools.by(FullScreenPage.EXIT_BUTTON_LOCATOR).wait(10000).untilPresent();
    }
    async getExitFullScreenUrl() {
        const exitButton = await this.tools.by(FullScreenPage.EXIT_BUTTON_LOCATOR).getElement();
        return await exitButton.getAttribute("href");
    }
}
FullScreenPage.EXIT_BUTTON_LOCATOR = By.xpath("//a[@data-testid='exit-fullscreen-button']");
export default FullScreenPage;
//# sourceMappingURL=FullScreenPage.js.map