import { By } from "selenium-webdriver";
import Editor from "../Editor";
class SwfEditor extends Editor {
    async isTextEditorPresent() {
        return await this.tools.by(SwfEditor.TEXT_EDITOR_LOCATOR).wait(1000).isPresent();
    }
    async isDiagramEditorPresent() {
        return await this.tools.by(SwfEditor.DIAGRAM_EDITOR_LOCATOR).wait(1000).isPresent();
    }
    async isTextEditorKeyboardShortcutsIconPresent() {
        return await this.isKeyboardShortcutsIconPresent(SwfEditor.TEXT_EDITOR_LOCATOR);
    }
    async isDiagramEditorKeyboardShortcutsIconPresent() {
        return await this.isKeyboardShortcutsIconPresent(SwfEditor.DIAGRAM_EDITOR_LOCATOR);
    }
    async getTextEditorContent() {
        await this.enterIFrame(SwfEditor.TEXT_EDITOR_LOCATOR);
        const textEditor = await this.tools.by(SwfEditor.EDITOR_TEXTAREA_LOCATOR).getElement();
        const content = await textEditor.getAttribute("value");
        await this.leaveIFrame();
        return content;
    }
    async enterIFrame(iframeBy) {
        const iFrame = await this.tools.by(iframeBy).getElement();
        await iFrame.enterFrame();
    }
    async leaveIFrame() {
        await this.tools.window().leaveFrame();
        await this.enter();
    }
    async isKeyboardShortcutsIconPresent(iFrameBy) {
        await this.enterIFrame(iFrameBy);
        const isPresent = await this.tools.by(SwfEditor.KEYBOARD_SHORTCUTS_ICON_LOCATOR).wait(1000).isPresent();
        await this.leaveIFrame();
        return isPresent;
    }
}
SwfEditor.DIAGRAM_EDITOR_LOCATOR = By.xpath("//iframe[contains(@src, 'serverless-workflow-diagram-editor-envelope.html')]");
SwfEditor.EDITOR_TEXTAREA_LOCATOR = By.xpath("//div[contains(@class, 'monaco-editor')]//textarea");
SwfEditor.KEYBOARD_SHORTCUTS_ICON_LOCATOR = By.xpath("//div[@data-ouia-component-id='keyboard-shortcuts-icon']");
SwfEditor.TEXT_EDITOR_LOCATOR = By.xpath("//iframe[contains(@src, 'serverless-workflow-text-editor-envelope.html')]");
export default SwfEditor;
//# sourceMappingURL=SwfEditor.js.map