import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useEffect, useMemo, useRef, useState } from "react";
import { Icon } from "@patternfly/react-core/dist/js/components/Icon";
import { ArrowUpIcon } from "@patternfly/react-icons/dist/js/icons/arrow-up-icon";
import { CheckCircleIcon } from "@patternfly/react-icons/dist/js/icons/check-circle-icon";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { OutlinedQuestionCircleIcon } from "@patternfly/react-icons/dist/js/icons/outlined-question-circle-icon";
import { DescriptionList, DescriptionListDescription, DescriptionListGroup, DescriptionListTerm, } from "@patternfly/react-core/dist/js/components/DescriptionList";
import { Card, CardBody, CardFooter, CardTitle } from "@patternfly/react-core/dist/js/components/Card";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Text, TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { formDmnI18n } from "./i18n";
import { I18nWrapped } from "@kie-tools-core/i18n/dist/react-components";
import "./styles.scss";
import { ErrorBoundary } from "@kie-tools/dmn-runner/dist/ErrorBoundary";
import { ExclamationTriangleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-triangle-icon";
import { DmnEvaluationStatus } from "@kie-tools/extended-services-api";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
const ISSUES_URL = "https://github.com/apache/incubator-kie-issues/issues";
const DATE_REGEX = /\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[1-2]\d|3[0-1])T(?:[0-1]\d|2[0-3]):[0-5]\d:[0-5]\dZ/;
var FormDmnOutputsStatus;
(function (FormDmnOutputsStatus) {
    FormDmnOutputsStatus[FormDmnOutputsStatus["EMPTY"] = 0] = "EMPTY";
    FormDmnOutputsStatus[FormDmnOutputsStatus["ERROR"] = 1] = "ERROR";
    FormDmnOutputsStatus[FormDmnOutputsStatus["VALID"] = 2] = "VALID";
})(FormDmnOutputsStatus || (FormDmnOutputsStatus = {}));
export function FormDmnOutputs({ openEvaluationTab, openBoxedExpressionEditor, openedBoxedExpressionEditorNodeId, ...props }) {
    const [formResultStatus, setFormResultStatus] = useState(FormDmnOutputsStatus.EMPTY);
    const [formResultError, setFormResultError] = useState(false);
    const i18n = useMemo(() => {
        var _a;
        formDmnI18n.setLocale((_a = props.locale) !== null && _a !== void 0 ? _a : navigator.language);
        return formDmnI18n.getCurrent();
    }, [props.locale]);
    const errorBoundaryRef = useRef(null);
    useEffect(() => {
        var _a;
        (_a = props.differences) === null || _a === void 0 ? void 0 : _a.forEach((difference, index) => {
            if (Object.keys(difference).length === 0) {
                return;
            }
            const updatedResult = document.getElementById(`${index}-dmn-result`);
            updatedResult === null || updatedResult === void 0 ? void 0 : updatedResult.classList.add("kogito--editor__dmn-form-result__leaf-updated");
        });
    }, [openedBoxedExpressionEditorNodeId, props.differences]);
    const onAnimationEnd = useCallback((e, index) => {
        e.preventDefault();
        e.stopPropagation();
        const updatedResult = document.getElementById(`${index}-dmn-result`);
        updatedResult === null || updatedResult === void 0 ? void 0 : updatedResult.classList.remove("kogito--editor__dmn-form-result__leaf-updated");
    }, []);
    const onOpenEvaluationTab = useCallback(() => {
        if (props.notificationsPanel) {
            openEvaluationTab === null || openEvaluationTab === void 0 ? void 0 : openEvaluationTab();
        }
    }, [props.notificationsPanel, openEvaluationTab]);
    const resultStatus = useCallback((evaluationStatus) => {
        switch (evaluationStatus) {
            case DmnEvaluationStatus.SUCCEEDED:
                return (_jsx(_Fragment, { children: _jsxs("div", { className: "kie-tools__dmn-form-result__evaluation", children: [_jsx(CheckCircleIcon, {}), props.notificationsPanel ? (_jsx("a", { onClick: onOpenEvaluationTab, className: "kogito--editor__dmn-form-result__evaluation-link", children: i18n.result.evaluation.succeeded })) : (_jsx("p", { className: "kogito--editor__dmn-form-result__evaluation-link", children: i18n.result.evaluation.succeeded }))] }) }));
            case DmnEvaluationStatus.SKIPPED:
                return (_jsx(_Fragment, { children: _jsxs("div", { className: "kie-tools__dmn-form-result__evaluation", children: [_jsx(Icon, { children: "\u21B7" }), props.notificationsPanel ? (_jsx("a", { onClick: onOpenEvaluationTab, className: "kogito--editor__dmn-form-result__evaluation-link", children: i18n.result.evaluation.skipped })) : (_jsx("p", { className: "kogito--editor__dmn-form-result__evaluation-link", children: i18n.result.evaluation.skipped }))] }) }));
            case DmnEvaluationStatus.FAILED:
                return (_jsx(_Fragment, { children: _jsxs("div", { className: "kie-tools__dmn-form-result__evaluation", children: [_jsx(ExclamationCircleIcon, {}), props.notificationsPanel ? (_jsx("a", { onClick: onOpenEvaluationTab, className: "kogito--editor__dmn-form-result__evaluation-link", children: i18n.result.evaluation.failed })) : (_jsx("p", { className: "kogito--editor__dmn-form-result__evaluation-link", children: i18n.result.evaluation.failed }))] }) }));
        }
    }, [
        i18n.result.evaluation.failed,
        i18n.result.evaluation.skipped,
        i18n.result.evaluation.succeeded,
        onOpenEvaluationTab,
        props.notificationsPanel,
    ]);
    const result = useCallback((dmnFormResult, parentKey) => {
        switch (typeof dmnFormResult) {
            case "boolean":
                return dmnFormResult ? _jsx("i", { children: "true" }) : _jsx("i", { children: "false" });
            case "number":
                return dmnFormResult;
            case "string":
                if (dmnFormResult.match(DATE_REGEX)) {
                    const current = new Date(dmnFormResult);
                    return (_jsx(_Fragment, { children: _jsx(Tooltip, { content: _jsx(I18nWrapped, { components: { date: current.toString() }, children: i18n.result.dateTooltip }), children: _jsxs("div", { className: "kogito--editor__dmn-form-result__results-date", children: [_jsx("p", { className: "kogito--editor__dmn-form-result__results-date", children: dmnFormResult }), _jsx(OutlinedQuestionCircleIcon, {})] }) }, `date-tooltip-${dmnFormResult}`) }));
                }
                return dmnFormResult;
            case "object":
                if (!dmnFormResult) {
                    return _jsx("i", { children: "(null)" });
                }
                if (Array.isArray(dmnFormResult)) {
                    if (dmnFormResult.length === 0) {
                        return (_jsxs(_Fragment, { children: [parentKey && _jsx(DescriptionListTerm, { children: parentKey }), _jsx("i", { children: "(null)" })] }));
                    }
                    return (_jsx(DescriptionList, { children: _jsx(DescriptionListGroup, { style: {
                                boxShadow: "0 0px 3px rgba(3, 3, 3, 0.15)",
                                padding: "10px",
                            }, children: dmnFormResult.map((dmnResult, index) => (_jsxs(React.Fragment, { children: [_jsx(DescriptionListTerm, { children: parentKey ? `${parentKey}-${index}` : index }), _jsx(DescriptionListDescription, { children: result(dmnResult) })] }, `array-result-${index}`))) }) }));
                }
                return (_jsx(DescriptionList, { children: _jsx(DescriptionListGroup, { style: {
                            boxShadow: "0 0px 3px rgba(3, 3, 3, 0.15)",
                            padding: "10px",
                        }, children: Object.entries(dmnFormResult).map(([key, value]) => (_jsxs(React.Fragment, { children: [value === null && (_jsx(DescriptionListTerm, { children: parentKey ? `${parentKey}-${key}` : key })), value !== null && typeof value !== "object" && (_jsx(DescriptionListTerm, { children: parentKey ? `${parentKey}-${key}` : key })), _jsx(DescriptionListDescription, { children: result(value, parentKey ? `${parentKey}-${key}` : key) })] }, `object-result-${key}-${value}`))) }) }));
            default:
                return _jsx("i", { children: "(null)" });
        }
    }, [i18n]);
    const onOpenBoxedExpressionEditor = useCallback((nodeId) => {
        return openBoxedExpressionEditor === null || openBoxedExpressionEditor === void 0 ? void 0 : openBoxedExpressionEditor(nodeId);
    }, [openBoxedExpressionEditor]);
    const resultsToRender = useMemo(() => {
        var _a;
        return (_a = props.results) === null || _a === void 0 ? void 0 : _a.map((dmnFormResult, index) => (_jsx("div", { className: "kogito--editor__dmn-form-result__results", children: _jsxs(Card, { id: `${index}-dmn-result`, isFlat: true, className: openedBoxedExpressionEditorNodeId === dmnFormResult.decisionId
                    ? "kogito--editor__dmn-form-result__results-card-highlight"
                    : "kogito--editor__dmn-form-result__results-card", onAnimationEnd: (e) => onAnimationEnd(e, index), children: [_jsx(CardTitle, { children: _jsxs(Flex, { justifyContent: { default: "justifyContentSpaceBetween" }, flexWrap: { default: "nowrap" }, children: [_jsx(Title, { headingLevel: "h2", children: dmnFormResult.decisionName }), openBoxedExpressionEditor !== undefined && (_jsx(Button, { variant: "plain", title: `Open '${dmnFormResult.decisionName}' expression`, icon: _jsx(ArrowUpIcon, {}), onClick: () => onOpenBoxedExpressionEditor === null || onOpenBoxedExpressionEditor === void 0 ? void 0 : onOpenBoxedExpressionEditor(dmnFormResult.decisionId) }))] }) }), _jsx(CardBody, { isFilled: true, children: result(dmnFormResult.result) }), _jsx(CardFooter, { children: resultStatus(dmnFormResult.evaluationStatus) })] }) }, `${index}-dmn-result`)));
    }, [
        props.results,
        openedBoxedExpressionEditorNodeId,
        openBoxedExpressionEditor,
        result,
        resultStatus,
        onAnimationEnd,
        onOpenBoxedExpressionEditor,
    ]);
    const formResultErrorMessage = useMemo(() => (_jsx("div", { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: ExclamationTriangleIcon }), _jsx(TextContent, { children: _jsx(Text, { component: "h2", children: i18n.result.error.title }) }), _jsxs(EmptyStateBody, { children: [_jsx(TextContent, { children: i18n.result.error.explanation }), _jsx("br", {}), _jsx(TextContent, { children: _jsx(I18nWrapped, { components: {
                                    jira: (_jsx("a", { href: ISSUES_URL, target: "_blank", rel: "noopener noreferrer", children: ISSUES_URL })),
                                }, children: i18n.result.error.message }) })] })] }) })), [i18n]);
    useEffect(() => {
        if (resultsToRender && resultsToRender.length > 0) {
            setFormResultStatus(FormDmnOutputsStatus.VALID);
        }
        else if (formResultError) {
            setFormResultStatus(FormDmnOutputsStatus.ERROR);
        }
        else {
            setFormResultStatus(FormDmnOutputsStatus.EMPTY);
        }
    }, [resultsToRender, formResultError]);
    useEffect(() => {
        var _a;
        (_a = errorBoundaryRef.current) === null || _a === void 0 ? void 0 : _a.reset();
    }, [props.results]);
    return (_jsxs(_Fragment, { children: [formResultStatus === FormDmnOutputsStatus.EMPTY && (_jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: InfoCircleIcon }), _jsx(TextContent, { children: _jsx(Text, { component: "h2", children: i18n.result.withoutResponse.title }) }), _jsx(EmptyStateBody, { children: _jsx(TextContent, { children: _jsx(Text, { children: i18n.result.withoutResponse.explanation }) }) })] })), formResultStatus === FormDmnOutputsStatus.ERROR && formResultErrorMessage, formResultStatus === FormDmnOutputsStatus.VALID && (_jsx(ErrorBoundary, { ref: errorBoundaryRef, setHasError: setFormResultError, error: formResultErrorMessage, children: _jsx("div", { "data-testid": "dmn-form-result", children: resultsToRender }) }))] }));
}
//# sourceMappingURL=FormDmnOutputs.js.map