const INTERVAL = `
[
  $v.Interval ~> $map(function($v, $i) {
    {
      "type": "element", 
      "name": "Interval", 
      "attributes": {
        "closure": $v.closure,
        "leftMargin": $v.leftMargin,
        "rightMargin": $v.rightMargin
      }
    }
  })
]`;
const VALUE = `
[
  $v.Value ~> $map(function($v, $i) {
    {
      "type": "element", 
      "name": "Value", 
      "attributes": {
        "value": $v.value,
        "displayValue": $v.displayValue,
        "property": $v.property
      }
    }
  })
]`;
const DATA_FIELD = `
[
  $v.DataField ~> $map(function($v, $i) {
    {
      "type": "element", 
      "name": "DataField", 
      "attributes": {
        "name": $v.name,
        "displayName": $v.displayName,
        "optype": $v.optype,
        "dataType": $v.dataType,
        "taxonomy": $v.taxonomy,
        "isCyclic": $v.isCyclic
      },
      "elements": $append(${INTERVAL}, ${VALUE})
    }
  })
]`;
export const DATA_DICTIONARY = `
[
  DataDictionary ~> $map(function($v, $i) {
    {
      "type": "element",
      "name": "DataDictionary",
      "attributes": {
        "numberOfFields": DataDictionary.DataField ? $count(DataDictionary.DataField) : undefined
      },
      "elements": ${DATA_FIELD}
    }
  })
]`;
//# sourceMappingURL=DataDictionary.js.map