import { Characteristics, MiningSchema, Scorecard } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
import { TARGETS } from "./Targets";
const COMPLEX_PARTIAL_SCORE = `
  "ComplexPartialScore": $v.elements[(name = "ComplexPartialScore")] ~> $map(function($v, $i) {
    $v
})`;
const ATTRIBUTE = `
{
  "Attribute": [$v.elements[(name = "Attribute")] ~> $map(function($v, $i) {
    $merge([
      $v.attributes,
      {
        "partialScore": $number($v.attributes.partialScore),
        "predicate": $json2uiPredicateFactory($v.elements[0]),
        ${COMPLEX_PARTIAL_SCORE}        
      }
    ])
  })]
}`;
const CHARACTERISTICS = `
"Characteristics": {
  "Characteristic": [$v.elements[(name = "Characteristics")].elements[(name = "Characteristic")] ~> $map(function($v, $i) {
    $merge([
      $v.attributes,
      {
        "baselineScore": $number($v.attributes.baselineScore)
      },
      ${ATTRIBUTE}
    ])
  })]
}`;
export const SCORE_CARD = `
elements.elements[(name = "Scorecard")] ~> $map(function($v, $i) {
  $merge([
    $scorecardFactory(),
    $v.attributes,
    {
      "isScorable": $eval($v.attributes.isScorable),
      "useReasonCodes": $eval($v.attributes.useReasonCodes),
      "initialScore": $number($v.attributes.initialScore),
      "baselineScore": $number($v.attributes.baselineScore),
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${CHARACTERISTICS}, 
      ${MODEL_STATS},
      ${MODEL_EXPLANATION},
      ${MODEL_VERIFICATION},
      ${TARGETS},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function scorecardFactory() {
    return new Scorecard({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        Characteristics: new Characteristics({ Characteristic: [] }),
        functionName: "regression",
    });
}
//# sourceMappingURL=Scorecard.js.map