import { BaselineModel, MiningSchema, TestDistributions } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
export const BASELINE_MODEL = `
elements.elements[(name = "BaselineModel")] ~> $map(function($v, $i) {
  $merge([
    $baselineModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${MODEL_STATS},
      ${MODEL_EXPLANATION},
      ${MODEL_VERIFICATION},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function baselineModelFactory() {
    return new BaselineModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        TestDistributions: new TestDistributions({ Baseline: {}, field: "", testStatistic: "CUSUM" }),
        functionName: "regression",
    });
}
//# sourceMappingURL=BaselineModel.js.map