import { EditorFactory, EditorInitArgs, KogitoEditorEnvelopeContextType } from "@kie-tools-core/editor/dist/api";
import { JavaCodeCompletionApi } from "@kie-tools-core/vscode-java-code-completion/dist/api";
import { DiagramExposedInteropApi } from "../../api/DiagramExposedInteropApi";
import { ServerlessWorkflowDiagramEditor } from "../../envelope";
import { VsCodeServerlessWorkflowDiagramEditorChannelApi } from "../api/VsCodeServerlessWorkflowDiagramEditorChannelApi";
import { ServerlessWorkflowDiagramEditorEnvelopeApi } from "../../api";
export interface CustomWindow extends Window {
    envelope: {
        javaCodeCompletionService: JavaCodeCompletionApi;
        diagramService: DiagramExposedInteropApi;
    };
}
export declare class VsCodeServerlessWorkflowDiagramEditorFactory implements EditorFactory<ServerlessWorkflowDiagramEditor, ServerlessWorkflowDiagramEditorEnvelopeApi, VsCodeServerlessWorkflowDiagramEditorChannelApi> {
    private readonly gwtEditorEnvelopeConfig;
    constructor(gwtEditorEnvelopeConfig: {
        shouldLoadResourcesDynamically: boolean;
    });
    createEditor(ctx: KogitoEditorEnvelopeContextType<ServerlessWorkflowDiagramEditorEnvelopeApi, VsCodeServerlessWorkflowDiagramEditorChannelApi>, initArgs: EditorInitArgs): Promise<ServerlessWorkflowDiagramEditor>;
}
//# sourceMappingURL=VsCodeServerlessWorkflowDiagramEditorFactory.d.ts.map