import { Element } from "./themes/Element";
import { FeelSyntacticSymbolNature } from "@kie-tools/dmn-feel-antlr4-parser";
export class SemanticTokensProvider {
    constructor(feelIdentifiers, expressionId, setCurrentParsedExpression) {
        this.feelIdentifiers = feelIdentifiers;
        this.expressionId = expressionId;
        this.setCurrentParsedExpression = setCurrentParsedExpression;
    }
    getLegend() {
        return {
            tokenTypes: Object.values(Element).filter((x) => typeof x === "string"),
            tokenModifiers: [],
        };
    }
    provideDocumentSemanticTokens(model, lastResultId, token) {
        var _a;
        const tokenTypes = new Array();
        if (!this.feelIdentifiers) {
            return;
        }
        const text = model.getValue().replaceAll("\r\n", "\n");
        const contentByLines = model.getLinesContent();
        const parsedExpression = this.feelIdentifiers.parse({
            identifierContextUuid: (_a = this.expressionId) !== null && _a !== void 0 ? _a : "",
            expression: text,
        });
        this.setCurrentParsedExpression(parsedExpression);
        for (const feelIdentifiedSymbol of parsedExpression.feelIdentifiedSymbols) {
            let lineOffset = 0;
            for (let i = 0; i < feelIdentifiedSymbol.startLine; i++) {
                lineOffset += contentByLines[i].length + 1;
            }
            feelIdentifiedSymbol.startIndex -= lineOffset;
        }
        let startOfPreviousVariable = 0;
        let previousLine = 0;
        for (const feelIdentifiedSymbol of parsedExpression.feelIdentifiedSymbols) {
            if (previousLine != feelIdentifiedSymbol.startLine) {
                startOfPreviousVariable = 0;
            }
            if (feelIdentifiedSymbol.startLine === feelIdentifiedSymbol.endLine) {
                tokenTypes.push(feelIdentifiedSymbol.startLine - previousLine, feelIdentifiedSymbol.startIndex - startOfPreviousVariable, feelIdentifiedSymbol.length, this.getTokenTypeIndex(feelIdentifiedSymbol.feelSymbolNature), 0);
                previousLine = feelIdentifiedSymbol.startLine;
                startOfPreviousVariable = feelIdentifiedSymbol.startIndex;
            }
            else {
                tokenTypes.push(feelIdentifiedSymbol.startLine - previousLine, feelIdentifiedSymbol.startIndex - startOfPreviousVariable, contentByLines[feelIdentifiedSymbol.startLine - previousLine].length - feelIdentifiedSymbol.startIndex, this.getTokenTypeIndex(feelIdentifiedSymbol.feelSymbolNature), 0);
                let remainingChars = feelIdentifiedSymbol.length -
                    1 -
                    (contentByLines[feelIdentifiedSymbol.startLine - previousLine].length - feelIdentifiedSymbol.startIndex);
                const remainingLines = feelIdentifiedSymbol.endLine - feelIdentifiedSymbol.startLine;
                let currentLine = feelIdentifiedSymbol.startLine + 1;
                for (let i = 0; i < remainingLines; i++) {
                    let toColorize = remainingChars;
                    if (toColorize > contentByLines[currentLine].length) {
                        toColorize = contentByLines[currentLine].length;
                    }
                    tokenTypes.push(1, 0, toColorize, this.getTokenTypeIndex(feelIdentifiedSymbol.feelSymbolNature), 0);
                    remainingChars -= toColorize + 1;
                    currentLine++;
                }
                startOfPreviousVariable = 0;
                previousLine = feelIdentifiedSymbol.endLine;
            }
        }
        return {
            data: new Uint32Array(tokenTypes),
            resultId: undefined,
        };
    }
    releaseDocumentSemanticTokens(resultId) {
    }
    getTokenTypeIndex(symbolType) {
        switch (symbolType) {
            default:
            case FeelSyntacticSymbolNature.LocalVariable:
            case FeelSyntacticSymbolNature.GlobalVariable:
                return Element.Variable;
            case FeelSyntacticSymbolNature.DynamicVariable:
                return Element.DynamicVariable;
            case FeelSyntacticSymbolNature.Unknown:
                return Element.UnknownVariable;
            case FeelSyntacticSymbolNature.Invocable:
                return Element.FunctionCall;
            case FeelSyntacticSymbolNature.Parameter:
                return Element.FunctionParameterVariable;
        }
    }
}
//# sourceMappingURL=semanticTokensProvider.js.map