import * as Monaco from "@kie-tools-core/monaco-editor";
import * as React from "react";
import { FeelIdentifiers } from "@kie-tools/dmn-feel-antlr4-parser";
export declare const EXPRESSION_PROPERTIES_SEPARATOR = ".";
export type SuggestionProvider = (feelExpression: string, row: number, col: number) => Monaco.languages.CompletionItem[];
export interface FeelInputProps {
    enabled: boolean;
    value?: string;
    suggestionProvider?: SuggestionProvider;
    onBlur?: (value: string) => void;
    onPreviewChanged?: (preview: string) => void;
    onKeyDown?: (event: Monaco.IKeyboardEvent, value: string) => void;
    onChange?: (event: Monaco.editor.IModelContentChangedEvent, value: string, preview: string) => void;
    options?: Monaco.editor.IStandaloneEditorConstructionOptions;
    feelIdentifiers?: FeelIdentifiers;
    expressionId?: string;
}
export interface FeelInputRef {
    setMonacoValue: (newValue: string) => void;
    getMonacoValue: () => string | undefined;
    insertNewLineToMonaco: () => void;
    isSuggestionWidgetOpen: () => boolean;
}
export declare const FeelInput: React.ForwardRefExoticComponent<FeelInputProps & React.RefAttributes<FeelInputRef>>;
//# sourceMappingURL=FeelInput.d.ts.map