import { ResourceFetch } from "../../fetch/ResourceFetch";
import { HttpMethod } from "../../fetch/FetchConstants";
import { OpenshiftApiVersions } from "./api";
import { ResourceDataSource, commonLabels, runtimeLabels } from "../common";
export const IMAGE_STREAM_TEMPLATE = (args) => ({
    apiVersion: OpenshiftApiVersions.IMAGE_STREAM,
    kind: "ImageStream",
    metadata: {
        name: args.resourceName,
        namespace: args.namespace,
        labels: {
            ...commonLabels({ ...args }),
            ...runtimeLabels(),
        },
    },
    spec: {
        lookupPolicy: {
            local: true,
        },
    },
});
export class CreateImageStream extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.POST;
    }
    body() {
        return JSON.stringify(this.args.resourceDataSource === ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : IMAGE_STREAM_TEMPLATE({ ...this.args }));
    }
    endpoint() {
        return `/apis/${OpenshiftApiVersions.IMAGE_STREAM}/namespaces/${this.args.namespace}/imagestreams`;
    }
}
export class DeleteImageStream extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.DELETE;
    }
    endpoint() {
        return `/apis/${OpenshiftApiVersions.IMAGE_STREAM}/namespaces/${this.args.namespace}/imagestreams/${this.args.resourceName}`;
    }
}
//# sourceMappingURL=ImageStream.js.map