import { ResourceFetch } from "../../fetch/ResourceFetch";
import { ContentTypes, HttpMethod } from "../../fetch/FetchConstants";
import { OpenshiftApiVersions } from "./api";
import { BUILD_IMAGE_TAG_VERSION, commonLabels, runtimeLabels, ResourceDataSource, } from "../common";
export const BUILD_CONFIG_TEMPLATE = (args) => ({
    apiVersion: OpenshiftApiVersions.BUILD_CONFIG,
    kind: "BuildConfig",
    metadata: {
        name: args.resourceName,
        namespace: args.namespace,
        labels: {
            ...commonLabels({ ...args }),
            ...runtimeLabels(),
        },
    },
    spec: {
        output: {
            to: {
                kind: "ImageStreamTag",
                name: `${args.resourceName}:${BUILD_IMAGE_TAG_VERSION}`,
            },
        },
        strategy: {
            type: "Docker",
        },
        source: {
            type: "Binary",
            binary: {},
        },
        resources: {
            limits: {
                memory: "4Gi",
            },
        },
    },
});
export class CreateBuildConfig extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.POST;
    }
    body() {
        return JSON.stringify(this.args.resourceDataSource === ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : BUILD_CONFIG_TEMPLATE({ ...this.args }));
    }
    endpoint() {
        return `/apis/${OpenshiftApiVersions.BUILD_CONFIG}/namespaces/${this.args.namespace}/buildconfigs`;
    }
}
export class DeleteBuildConfig extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.DELETE;
    }
    endpoint() {
        return `/apis/${OpenshiftApiVersions.BUILD_CONFIG}/namespaces/${this.args.namespace}/buildconfigs/${this.args.resourceName}`;
    }
}
export class InstantiateBinary extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.POST;
    }
    body() {
        return this.args.zipBlob;
    }
    contentType() {
        return ContentTypes.APPLICATION_ZIP;
    }
    endpoint() {
        return `/apis/${OpenshiftApiVersions.BUILD_CONFIG}/namespaces/${this.args.namespace}/buildconfigs/${this.args.resourceName}/instantiatebinary?name=${this.args.resourceName}&namespace=${this.args.namespace}`;
    }
}
//# sourceMappingURL=BuildConfig.js.map