import { ResourceFetch } from "../../fetch/ResourceFetch";
import { HttpMethod } from "../../fetch/FetchConstants";
import { Service } from "kubernetes-models/v1";
import { ResourceDataSource, commonLabels, runtimeLabels } from "../common";
export const SERVICE_TEMPLATE = (args) => {
    return new Service({
        metadata: {
            name: args.resourceName,
            namespace: args.namespace,
            labels: {
                ...commonLabels({ ...args }),
                ...runtimeLabels(),
            },
        },
        spec: {
            ports: [
                {
                    name: "8080-tcp",
                    protocol: "TCP",
                    port: 8080,
                    targetPort: 8080,
                },
            ],
            selector: {
                app: args.resourceName,
                deploymentconfig: args.resourceName,
            },
        },
    }).toJSON();
};
export class CreateService extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.POST;
    }
    body() {
        return JSON.stringify(this.args.resourceDataSource === ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : SERVICE_TEMPLATE({ ...this.args }));
    }
    endpoint() {
        return `/api/${Service.apiVersion}/namespaces/${this.args.namespace}/services`;
    }
}
export class ListServices extends ResourceFetch {
    method() {
        return HttpMethod.GET;
    }
    endpoint() {
        return `/api/${Service.apiVersion}/namespaces/${this.args.namespace}/services`;
    }
}
export class DeleteService extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    body() {
        return JSON.stringify({
            propagationPolicy: "Background",
        });
    }
    method() {
        return HttpMethod.DELETE;
    }
    endpoint() {
        return `/api/${Service.apiVersion}/namespaces/${this.args.namespace}/services/${this.args.resourceName}`;
    }
}
//# sourceMappingURL=Service.js.map