import { CreateResourceFetchArgs, ResourceFetch, UniqueResourceFetchArgs } from "../../fetch/ResourceFetch";
import { HttpMethod } from "../../fetch/FetchConstants";
import { ISecret } from "kubernetes-models/v1";
import { ResourceDataSource, ResourceMetadataEnforcer } from "../common";
export type CreateSecretTemplateArgs = {
    data: Record<string, string>;
    resourceDataSource: ResourceDataSource.TEMPLATE;
};
export type CreateSecretArgs = CreateResourceFetchArgs & (CreateSecretTemplateArgs | {
    descriptor: SecretDescriptor;
    resourceDataSource: ResourceDataSource.PROVIDED;
});
export type SecretDescriptor = ISecret & ResourceMetadataEnforcer;
export declare const SECRET_TEMPLATE: (args: CreateResourceFetchArgs & CreateSecretTemplateArgs) => SecretDescriptor;
export declare class CreateSecret extends ResourceFetch {
    protected args: CreateSecretArgs;
    constructor(args: CreateSecretArgs);
    method(): HttpMethod;
    body(): string;
    endpoint(): string;
}
export declare class DeleteSecret extends ResourceFetch {
    protected args: UniqueResourceFetchArgs;
    constructor(args: UniqueResourceFetchArgs);
    method(): HttpMethod;
    endpoint(): string;
}
//# sourceMappingURL=Secret.d.ts.map