import { HttpMethod } from "../../fetch/FetchConstants";
import { ResourceFetch, } from "../../fetch/ResourceFetch";
import { Deployment } from "kubernetes-models/apps/v1";
import { ResourceDataSource, ResourceLabelNames, commonLabels, runtimeLabels, } from "../common";
export const DEPLOYMENT_TEMPLATE = (args) => {
    var _a;
    const annotations = {
        [ResourceLabelNames.URI]: args.uri,
        [ResourceLabelNames.WORKSPACE_NAME]: args.workspaceName,
    };
    return new Deployment({
        metadata: {
            annotations,
            name: args.resourceName,
            namespace: args.namespace,
            labels: {
                ...commonLabels({ ...args }),
                ...runtimeLabels(),
            },
        },
        spec: {
            replicas: 1,
            selector: {
                matchLabels: {
                    app: args.resourceName,
                },
            },
            template: {
                metadata: {
                    labels: {
                        app: args.resourceName,
                        deploymentconfig: args.resourceName,
                    },
                },
                spec: {
                    containers: [
                        {
                            name: args.resourceName,
                            image: args.containerImageUrl,
                            ports: [
                                {
                                    containerPort: 8080,
                                    protocol: "TCP",
                                },
                            ],
                            env: args.envVars,
                            imagePullPolicy: (_a = args.imagePullPolicy) !== null && _a !== void 0 ? _a : "Always",
                        },
                    ],
                },
            },
        },
    }).toJSON();
};
export class CreateDeployment extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.POST;
    }
    body() {
        return JSON.stringify(this.args.resourceDataSource === ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : DEPLOYMENT_TEMPLATE({ ...this.args }));
    }
    endpoint() {
        return `/apis/${Deployment.apiVersion}/namespaces/${this.args.namespace}/deployments`;
    }
}
export class ListDeployments extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.GET;
    }
    endpoint() {
        const selector = this.args.labelSelector ? `?labelSelector=${this.args.labelSelector}` : "";
        return `/apis/${Deployment.apiVersion}/namespaces/${this.args.namespace}/deployments${selector}`;
    }
}
export class DeleteDeployment extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.DELETE;
    }
    body() {
        return JSON.stringify({
            propagationPolicy: "Background",
        });
    }
    endpoint() {
        return `/apis/${Deployment.apiVersion}/namespaces/${this.args.namespace}/deployments/${this.args.resourceName}`;
    }
}
export class GetDeployment extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.GET;
    }
    endpoint() {
        return `/apis/${Deployment.apiVersion}/namespaces/${this.args.namespace}/deployments/${this.args.resourceName}`;
    }
}
export class UpdateDeployment extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.PUT;
    }
    body() {
        return JSON.stringify(this.args.descriptor);
    }
    endpoint() {
        return `/apis/${Deployment.apiVersion}/namespaces/${this.args.namespace}/deployments/${this.args.resourceName}`;
    }
}
//# sourceMappingURL=Deployment.js.map