import { HttpMethod } from "../../fetch/FetchConstants";
import { ResourceFetch, } from "../../fetch/ResourceFetch";
import { OpenShiftLabelNames } from "../openshift/api";
import { BUILD_IMAGE_TAG_VERSION, ResourceDataSource, ResourceLabelNames, commonLabels, runtimeLabels, } from "../common";
import { Service as KnativeService, } from "@kubernetes-models/knative/serving.knative.dev/v1/Service";
export const KNATIVE_SERVICE_TEMPLATE = (args) => {
    const imageStreamTrigger = {
        from: {
            name: `${args.resourceName}:${BUILD_IMAGE_TAG_VERSION}`,
            namespace: args.namespace,
            kind: "ImageStreamTag",
        },
        pause: false,
        fieldPath: `spec.template.spec.containers[?(@.name=="${args.resourceName}")].image`,
    };
    const annotations = {
        [OpenShiftLabelNames.TRIGGERS]: JSON.stringify([imageStreamTrigger]),
        [ResourceLabelNames.URI]: args.uri,
        [ResourceLabelNames.WORKSPACE_NAME]: args.workspaceName,
    };
    return new KnativeService({
        metadata: {
            name: args.resourceName,
            namespace: args.namespace,
            labels: {
                ...commonLabels({ ...args }),
                ...runtimeLabels(),
            },
            annotations,
        },
        spec: {
            template: {
                spec: {
                    containers: [
                        {
                            name: args.resourceName,
                            image: `image-registry.openshift-image-registry.svc:5000/${args.namespace}/${args.resourceName}:${BUILD_IMAGE_TAG_VERSION}`,
                        },
                    ],
                },
            },
        },
    }).toJSON();
};
export class CreateKnativeService extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.POST;
    }
    body() {
        return JSON.stringify(this.args.resourceDataSource === ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : KNATIVE_SERVICE_TEMPLATE({ ...this.args }));
    }
    endpoint() {
        return `/apis/${KnativeService.apiVersion}/namespaces/${this.args.namespace}/services`;
    }
}
export class ListKnativeServices extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.GET;
    }
    endpoint() {
        const selector = this.args.labelSelector ? `?labelSelector=${this.args.labelSelector}` : "";
        return `/apis/${KnativeService.apiVersion}/namespaces/${this.args.namespace}/services${selector}`;
    }
}
export class DeleteKnativeService extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.DELETE;
    }
    endpoint() {
        return `/apis/${KnativeService.apiVersion}/namespaces/${this.args.namespace}/services/${this.args.resourceName}`;
    }
}
export class GetKnativeService extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.GET;
    }
    endpoint() {
        return `/apis/${KnativeService.apiVersion}/namespaces/${this.args.namespace}/services/${this.args.resourceName}`;
    }
}
//# sourceMappingURL=KnativeService.js.map