import { CreateResourceFetchArgs, ResourceFetch, UniqueResourceFetchArgs } from "../../fetch/ResourceFetch";
import { ResourceDataSource, ResourceDescriptor } from "../common";
import { HttpMethod } from "../../fetch/FetchConstants";
export interface SecretKeyRef {
    key: string;
    name: string;
}
export interface SinkRef {
    apiVersion: string;
    kind: string;
    name: string;
}
export interface KafkaSourceSpec {
    bootstrapServers: string[];
    consumerGroup: string;
    net: {
        tls: {
            enable: boolean;
        };
        sasl: {
            enable: boolean;
            type: {
                secretKeyRef: SecretKeyRef;
            };
            password: {
                secretKeyRef: SecretKeyRef;
            };
            user: {
                secretKeyRef: SecretKeyRef;
            };
        };
    };
    sink: {
        ref: SinkRef;
    };
    topics: string[];
}
export interface KafkaSourceDescriptor extends ResourceDescriptor {
    spec: KafkaSourceSpec;
}
export interface CreateKafkaSourceTemplateArgs {
    sinkService: string;
    bootstrapServers: string[];
    topics: string[];
    secret: {
        name: string;
        keyId: string;
        keySecret: string;
        keyMechanism: string;
    };
    resourceDataSource: ResourceDataSource.TEMPLATE;
}
export type CreateKafkaSourceArgs = CreateResourceFetchArgs & (CreateKafkaSourceTemplateArgs | {
    descriptor: KafkaSourceDescriptor;
    resourceDataSource: ResourceDataSource.PROVIDED;
});
export declare const KAFKA_SOURCE_TEMPLATE: (args: CreateResourceFetchArgs & CreateKafkaSourceTemplateArgs) => KafkaSourceDescriptor;
export declare class CreateKafkaSource extends ResourceFetch {
    protected args: CreateKafkaSourceArgs;
    constructor(args: CreateKafkaSourceArgs);
    method(): HttpMethod;
    body(): string;
    endpoint(): string;
}
export declare class DeleteKafkaSource extends ResourceFetch {
    protected args: UniqueResourceFetchArgs;
    constructor(args: UniqueResourceFetchArgs);
    method(): HttpMethod;
    endpoint(): string;
}
//# sourceMappingURL=KafkaSource.d.ts.map