import { IObjectMeta } from "@kubernetes-models/apimachinery/apis/meta/v1/ObjectMeta";
export type IpProtocol = "TCP" | "UDP" | "SCTP";
export type ResourceRequirements = {
    limits: {
        memory: string;
    };
};
export type ResourceMetadata = IObjectMeta & {
    name: string;
    namespace: string;
};
export interface ResourceDescriptor {
    apiVersion: string;
    kind: string;
    metadata: ResourceMetadata;
}
export interface ResourceMetadataEnforcer {
    metadata: ResourceMetadata;
}
export interface ResourceGroupDescriptor<T extends ResourceDescriptor> {
    items: T[];
}
export type Resource<T extends ResourceDescriptor = ResourceDescriptor> = ResourceDescriptor | ResourceGroupDescriptor<T>;
export interface EnvVar {
    name: string;
    value: string;
}
export declare const BUILD_IMAGE_TAG_VERSION = "1.0";
export declare const ResourceLabelNames: {
    URI: string;
    CREATED_BY: string;
    WORKSPACE_NAME: string;
};
export declare const commonLabels: (args: {
    resourceName: string;
    createdBy: string;
}) => {
    [x: string]: string;
};
export declare const runtimeLabels: () => {
    [x: string]: string;
};
export declare enum DeploymentState {
    UP = "UP",
    DOWN = "DOWN",
    IN_PROGRESS = "IN_PROGRESS",
    PREPARING = "PREPARING",
    ERROR = "ERROR"
}
export interface DeployedModel {
    resourceName: string;
    routeUrl: string;
    creationTimestamp: Date;
    state: DeploymentState;
}
export declare enum ResourceDataSource {
    PROVIDED = "PROVIDED",
    TEMPLATE = "TEMPLATE"
}
//# sourceMappingURL=common.d.ts.map