import { HttpMethod } from "./FetchConstants";
export interface ResourceFetchArgs {
    namespace: string;
}
export type UniqueResourceFetchArgs = ResourceFetchArgs & {
    resourceName: string;
};
export type CreateResourceFetchArgs = ResourceFetchArgs & {
    resourceName: string;
    createdBy: string;
};
export declare abstract class ResourceFetch {
    protected readonly args: ResourceFetchArgs;
    constructor(args: ResourceFetchArgs);
    abstract method(): HttpMethod;
    abstract endpoint(): string;
    body(): BodyInit | undefined;
    contentType(): string;
    name(): string;
}
//# sourceMappingURL=ResourceFetch.d.ts.map