import * as React from "react";
import { WorkspaceChannelApi, WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import { KeyboardShortcutsService } from "@kie-tools-core/keyboard-shortcuts/dist/envelope/KeyboardShortcutsService";
import * as TestScenarioEditor from "@kie-tools/scesim-editor/dist/TestScenarioEditor";
import { SceSimMarshaller, SceSimModel } from "@kie-tools/scesim-marshaller";
export declare const DMN_MODELS_SEARCH_GLOB_PATTERN = "**/*.dmn";
export declare const TARGET_DIRECTORY = "target/classes/";
export type TestScenarioEditorRootProps = {
    exposing: (s: TestScenarioEditorRoot) => void;
    isReadOnly: boolean;
    keyboardShortcutsService: KeyboardShortcutsService | undefined;
    onNewEdit: (edit: WorkspaceEdit) => void;
    onRequestWorkspaceFilesList: WorkspaceChannelApi["kogitoWorkspace_resourceListRequest"];
    onRequestWorkspaceFileContent: WorkspaceChannelApi["kogitoWorkspace_resourceContentRequest"];
    onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot: WorkspaceChannelApi["kogitoWorkspace_openFile"];
    workspaceRootAbsolutePosixPath: string;
};
export type TestScenarioEditorRootState = {
    externalModelsByNamespace: TestScenarioEditor.ExternalDmnsIndex;
    externalModelsManagerDoneBootstraping: boolean;
    isReadOnly: boolean;
    keyboardShortcutsRegistred: boolean;
    keyboardShortcutsRegisterIds: number[];
    marshaller: SceSimMarshaller | undefined;
    openFileNormalizedPosixPathRelativeToTheWorkspaceRoot: string | undefined;
    pointer: number;
    stack: SceSimModel[];
};
export declare class TestScenarioEditorRoot extends React.Component<TestScenarioEditorRootProps, TestScenarioEditorRootState> {
    private readonly externalModelsManagerDoneBootstraping;
    private readonly testScenarioEditorRef;
    constructor(props: TestScenarioEditorRootProps);
    undo(): Promise<void>;
    redo(): Promise<void>;
    getDiagramSvg(): Promise<string | undefined>;
    getContent(): Promise<string>;
    setContent(openFileNormalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    get model(): SceSimModel | undefined;
    private setExternalModelsByNamespace;
    private onModelChange;
    private onRequestExternalModelsAvailableToInclude;
    private onRequestToResolvePathRelativeToTheOpenFile;
    private onRequestExternalModelByPathsRelativeToTheOpenFile;
    private onOpenFileFromPathRelativeToTheOpenFile;
    componentDidUpdate(prevProps: Readonly<TestScenarioEditorRootProps>, prevState: Readonly<TestScenarioEditorRootState>, snapshot?: any): void;
    componentWillUnmount(): void;
    render(): JSX.Element;
}
//# sourceMappingURL=TestScenarioEditorRoot.d.ts.map