import { v4 as uuid } from "uuid";
export function addColumnWithEmptyProperty({ expressionElementsSteps, expressionIdentifierType, factAlias, factIdentifierClassName, factIdentifierName, factMappings, factMappingValuesTypes, targetColumnIndex, }) {
    addColumn({
        expressionElementsSteps,
        expressionIdentifierType,
        factAlias,
        factIdentifierClassName,
        factIdentifierName,
        factMappings: factMappings,
        factMappingValuesTypes,
        targetColumnIndex,
    });
}
export function addColumnWithEmptyInstanceAndProperty({ expressionIdentifierType, factMappings, factMappingValuesTypes, targetColumnIndex, }) {
    addColumn({
        expressionIdentifierType,
        factMappings: factMappings,
        factMappingValuesTypes,
        targetColumnIndex,
    });
}
function addColumn({ expressionElementsSteps, expressionIdentifierType, factAlias, factIdentifierClassName, factIdentifierName, factMappings, factMappingValuesTypes, targetColumnIndex, }) {
    const instanceDefaultNames = factMappings
        .filter((factMapping) => factMapping.factAlias.__$$text.startsWith("INSTANCE-"))
        .map((factMapping) => factMapping.factAlias.__$$text);
    const propertyDefaultNames = factMappings
        .filter((factMapping) => { var _a; return (_a = factMapping.expressionAlias) === null || _a === void 0 ? void 0 : _a.__$$text.startsWith("PROPERTY-"); })
        .map((factMapping) => factMapping.expressionAlias.__$$text);
    const newFactMapping = {
        className: { __$$text: "java.lang.Void" },
        columnWidth: { __$$text: 150 },
        expressionAlias: { __$$text: getNextAvailablePrefixedName(propertyDefaultNames, "PROPERTY") },
        expressionElements: expressionElementsSteps
            ? {
                ExpressionElement: expressionElementsSteps.map((ee) => {
                    return { step: { __$$text: ee } };
                }),
            }
            : undefined,
        expressionIdentifier: {
            name: { __$$text: `_${uuid()}`.toLocaleUpperCase() },
            type: { __$$text: expressionIdentifierType },
        },
        factAlias: {
            __$$text: factAlias !== null && factAlias !== void 0 ? factAlias : getNextAvailablePrefixedName(instanceDefaultNames, "INSTANCE"),
        },
        factIdentifier: {
            name: {
                __$$text: factIdentifierName !== null && factIdentifierName !== void 0 ? factIdentifierName : getNextAvailablePrefixedName(instanceDefaultNames, "INSTANCE"),
            },
            className: {
                __$$text: factIdentifierClassName !== null && factIdentifierClassName !== void 0 ? factIdentifierClassName : "java.lang.Void",
            },
        },
        factMappingValueType: { __$$text: "NOT_EXPRESSION" },
    };
    factMappings.splice(targetColumnIndex, 0, newFactMapping);
    factMappingValuesTypes.forEach((fmvt) => {
        fmvt.factMappingValues.FactMappingValue.splice(targetColumnIndex, 0, {
            expressionIdentifier: {
                name: { __$$text: newFactMapping.expressionIdentifier.name.__$$text },
                type: { __$$text: newFactMapping.expressionIdentifier.type.__$$text },
            },
            factIdentifier: {
                name: { __$$text: newFactMapping.factIdentifier.name.__$$text },
                className: { __$$text: newFactMapping.factIdentifier.className.__$$text },
            },
        });
    });
}
const getNextAvailablePrefixedName = (names, namePrefix, lastIndex = names.length) => {
    const candidate = `${namePrefix}-${lastIndex + 1}`;
    const elemWithCandidateName = names.indexOf(candidate);
    return elemWithCandidateName >= 0 ? getNextAvailablePrefixedName(names, namePrefix, lastIndex + 1) : candidate;
};
//# sourceMappingURL=addColumn.js.map