import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { DrawerActions, DrawerCloseButton, DrawerHead, DrawerPanelBody, DrawerPanelContent, } from "@patternfly/react-core/dist/js/components/Drawer";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { useTestScenarioEditorI18n } from "../i18n";
import { useTestScenarioEditorStore } from "../store/TestScenarioStoreContext";
import { TestScenarioEditorDock } from "../store/TestScenarioEditorStore";
import TestScenarioDrawerDataSelectorPanel from "./TestScenarioDrawerDataSelectorPanel";
import TestScenarioDrawerCheatSheetPanel from "./TestScenarioDrawerCheatSheetPanel";
import TestScenarioDrawerSettingsPanel from "../drawer/TestScenarioDrawerSettingsPanel";
function TestScenarioDrawerPanel({ onDrawerClose }) {
    var _a;
    const { i18n } = useTestScenarioEditorI18n();
    const navigation = useTestScenarioEditorStore((state) => state.navigation);
    const settingsModel = useTestScenarioEditorStore((state) => state.scesim.model.ScenarioSimulationModel.settings);
    const testScenarioType = (_a = settingsModel.type) === null || _a === void 0 ? void 0 : _a.__$$text.toUpperCase();
    return (_jsxs(DrawerPanelContent, { isResizable: true, minSize: "400px", defaultSize: "500px", children: [_jsxs(DrawerHead, { children: [_jsx(DrawerActions, { children: _jsx(DrawerCloseButton, { onClose: onDrawerClose }) }), _jsx(TextContent, { children: _jsx(Text, { component: TextVariants.h2, children: (() => {
                                switch (navigation.dock.selected) {
                                    case TestScenarioEditorDock.CHEATSHEET:
                                        return i18n.drawer.cheatSheet.title;
                                    case TestScenarioEditorDock.DATA_OBJECT:
                                        return testScenarioType === "DMN"
                                            ? i18n.drawer.dataSelector.titleDMN
                                            : i18n.drawer.dataSelector.titleRule;
                                    case TestScenarioEditorDock.SETTINGS:
                                        return i18n.drawer.settings.title;
                                    default:
                                        throw new Error("Wrong state, an invalid dock has been selected " + navigation.dock.selected);
                                }
                            })() }) }), _jsx(Divider, {})] }), _jsx(DrawerPanelBody, { children: (() => {
                    switch (navigation.dock.selected) {
                        case TestScenarioEditorDock.CHEATSHEET:
                            return _jsx(TestScenarioDrawerCheatSheetPanel, {});
                        case TestScenarioEditorDock.DATA_OBJECT:
                            return _jsx(TestScenarioDrawerDataSelectorPanel, {});
                        case TestScenarioEditorDock.SETTINGS:
                            return _jsx(TestScenarioDrawerSettingsPanel, {});
                        default:
                            throw new Error("Wrong state, an invalid dock has been selected " + navigation.dock.selected);
                    }
                })() })] }));
}
export default TestScenarioDrawerPanel;
//# sourceMappingURL=TestScenarioDrawerPanel.js.map