import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useImperativeHandle, useMemo, useRef, useState } from "react";
import { Drawer, DrawerContent, DrawerContentBody, DrawerPanelBody, DrawerPanelContent, } from "@patternfly/react-core/dist/js/components/Drawer";
import { yardEditorDictionaries, YardEditorI18nContext, yardEditorI18nDefaults } from "../i18n";
import { WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import { YardTextEditorOperation } from "../textEditor/YardTextEditorController";
import { YardTextEditor } from "../textEditor/YardTextEditor";
import { ChannelType, StateControlCommand } from "@kie-tools-core/editor/dist/api";
import { I18nDictionariesProvider } from "@kie-tools-core/i18n/dist/react-components";
import { YardUIEditor } from "../uiEditor";
import "./YardEditor.css";
import { deserialize } from "../model";
const RefForwardingYardEditor = (props, forwardedRef) => {
    const [file, setFile] = useState(undefined);
    const [yardData, setYardData] = useState();
    const yardTextEditorRef = useRef(null);
    useImperativeHandle(forwardedRef, () => {
        return {
            setContent: (normalizedPosixPathRelativeToTheWorkspaceRoot, newContent) => {
                try {
                    setFile({
                        content: newContent,
                        normalizedPosixPathRelativeToTheWorkspaceRoot,
                    });
                    setYardData(deserialize(newContent));
                    return Promise.resolve();
                }
                catch (e) {
                    console.error(e);
                    return Promise.reject();
                }
            },
            getContent: () => {
                var _a;
                return Promise.resolve(((_a = yardTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.getContent()) || "");
            },
            getPreview: () => {
                return Promise.resolve("");
            },
            undo: () => {
                var _a;
                return ((_a = yardTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo()) || Promise.resolve();
            },
            redo: () => {
                var _a;
                return ((_a = yardTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.redo()) || Promise.resolve();
            },
            validate: () => {
                return [];
            },
            setTheme: (theme) => {
                var _a;
                return ((_a = yardTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.setTheme(theme)) || Promise.resolve();
            },
            moveCursorToPosition: (position) => {
                var _a;
                (_a = yardTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.moveCursorToPosition(position);
            },
        };
    }, []);
    const setValidationErrors = useCallback((errors) => {
        if (!file) {
            return;
        }
        const notifications = errors.map((error) => ({
            type: "PROBLEM",
            normalizedPosixPathRelativeToTheWorkspaceRoot: file.normalizedPosixPathRelativeToTheWorkspaceRoot,
            severity: "ERROR",
            message: `${error.message}`,
            position: {
                startLineNumber: error.startLineNumber,
                startColumn: error.startColumn,
                endLineNumber: error.endLineNumber,
                endColumn: error.endColumn,
            },
        }));
        props.setNotifications.apply(file.normalizedPosixPathRelativeToTheWorkspaceRoot, notifications);
    }, [file, props.setNotifications]);
    const isVscode = useCallback(() => {
        return props.channelType === ChannelType.VSCODE_DESKTOP || props.channelType === ChannelType.VSCODE_WEB;
    }, [props.channelType]);
    const onContentChanged = useCallback((newContent, operation) => {
        var _a, _b;
        switch (operation) {
            case YardTextEditorOperation.EDIT:
                props.onNewEdit(new WorkspaceEdit(newContent));
                break;
            case YardTextEditorOperation.UNDO:
                if (!isVscode()) {
                    (_a = yardTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo();
                }
                props.onStateControlCommandUpdate(StateControlCommand.UNDO);
                break;
            case YardTextEditorOperation.REDO:
                if (!isVscode()) {
                    (_b = yardTextEditorRef.current) === null || _b === void 0 ? void 0 : _b.redo();
                }
                props.onStateControlCommandUpdate(StateControlCommand.REDO);
                break;
        }
        setYardData(deserialize(newContent));
    }, [props, isVscode]);
    const yardTextEditor = useMemo(() => file && (_jsx(YardTextEditor, { channelType: props.channelType, file: file, onContentChange: onContentChanged, setValidationErrors: setValidationErrors, ref: yardTextEditorRef, isReadOnly: props.isReadOnly })), [file, props.channelType, onContentChanged, setValidationErrors, props.isReadOnly]);
    const yardUIContainer = useMemo(() => file && (_jsx(I18nDictionariesProvider, { defaults: yardEditorI18nDefaults, dictionaries: yardEditorDictionaries, initialLocale: navigator.language, ctx: YardEditorI18nContext, children: _jsx(YardUIEditor, { yardData: yardData, isReadOnly: props.isReadOnly }) })), [file, yardData, props.isReadOnly]);
    return (_jsx(_Fragment, { children: (isVscode() && yardUIContainer) || (_jsx(Drawer, { className: "yard-drawer", isExpanded: true, isInline: true, children: _jsx(DrawerContent, { panelContent: _jsx(DrawerPanelContent, { isResizable: true, defaultSize: "50%", children: _jsx(DrawerPanelBody, { children: yardUIContainer }) }), children: _jsx(DrawerContentBody, { className: "drawer-content-body", children: yardTextEditor }) }) })) }));
};
export const YardEditor = React.forwardRef(RefForwardingYardEditor);
//# sourceMappingURL=YardEditor.js.map