"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EditorEnvelopeLocator = exports.EnvelopeMapping = exports.EnvelopeContentType = void 0;
var minimatch_1 = require("minimatch");
var EnvelopeContentType;
(function (EnvelopeContentType) {
    EnvelopeContentType[EnvelopeContentType["PATH"] = 0] = "PATH";
    EnvelopeContentType[EnvelopeContentType["CONTENT"] = 1] = "CONTENT";
})(EnvelopeContentType || (exports.EnvelopeContentType = EnvelopeContentType = {}));
var EnvelopeMapping = (function () {
    function EnvelopeMapping(args) {
        this.args = args;
        this.matcher = new minimatch_1.Minimatch(args.filePathGlob, { nocase: true, dot: true });
    }
    Object.defineProperty(EnvelopeMapping.prototype, "type", {
        get: function () {
            return this.args.type;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(EnvelopeMapping.prototype, "filePathGlob", {
        get: function () {
            return this.args.filePathGlob;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(EnvelopeMapping.prototype, "resourcesPathPrefix", {
        get: function () {
            return this.args.resourcesPathPrefix;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(EnvelopeMapping.prototype, "envelopeContent", {
        get: function () {
            return this.args.envelopeContent;
        },
        enumerable: false,
        configurable: true
    });
    return EnvelopeMapping;
}());
exports.EnvelopeMapping = EnvelopeMapping;
var EditorEnvelopeLocator = (function () {
    function EditorEnvelopeLocator(targetOrigin, envelopeMappings) {
        this.targetOrigin = targetOrigin;
        this.envelopeMappings = envelopeMappings;
    }
    EditorEnvelopeLocator.prototype.getEnvelopeMapping = function (path) {
        return this.envelopeMappings.find(function (mapping) {
            return mapping.matcher.match(path);
        });
    };
    EditorEnvelopeLocator.prototype.hasMappingFor = function (path) {
        return this.getEnvelopeMapping(path) !== undefined;
    };
    return EditorEnvelopeLocator;
}());
exports.EditorEnvelopeLocator = EditorEnvelopeLocator;
//# sourceMappingURL=EditorEnvelopeLocator.js.map