import { ELsNode, IEditorLanguageService, ShouldCompleteArgs, TranslateArgs } from "@kie-tools/json-yaml-language-service/dist/channel";
import { TextDocument } from "vscode-languageserver-textdocument";
import { CodeLens, CompletionItem, CompletionItemKind, Diagnostic, Position, Range } from "vscode-languageserver-types";
import { CodeCompletionStrategy, ShouldCreateCodelensArgs } from "./types";
export declare class YardYamlLanguageService implements IEditorLanguageService {
    private readonly ls;
    private readonly yamlELs;
    private readonly codeCompletionStrategy;
    constructor();
    getCompletionItems(args: {
        content: string;
        uri: string;
        cursorPosition: Position;
        cursorWordRange: Range;
    }): Promise<CompletionItem[]>;
    getCodeLenses(args: {
        content: string;
        uri: string;
    }): Promise<CodeLens[]>;
    getDiagnostics(args: {
        content: string;
        uriPath: string;
    }): Promise<Diagnostic[]>;
    getSchemaDiagnostics(args: {
        textDocument: TextDocument;
        fileMatch: string[];
    }): Promise<Diagnostic[]>;
    dispose(): void;
}
export declare class YardYamlCodeCompletionStrategy implements CodeCompletionStrategy {
    private eLsCodeCompletionStrategy;
    constructor();
    translate(args: TranslateArgs): string;
    formatLabel(label: string, completionItemKind: CompletionItemKind): string;
    getStartNodeValuePosition(document: TextDocument, node: ELsNode): Position | undefined;
    shouldComplete(args: ShouldCompleteArgs): boolean;
    shouldCreateCodelens(args: ShouldCreateCodelensArgs): boolean;
}
//# sourceMappingURL=YardYamlLanguageService.d.ts.map