import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { connectField, filterDOMProps } from "uniforms";
function LongTextField({ disabled, id, inputRef, label, name, onChange, placeholder, value, ...props }) {
    return (_jsxs("div", { "data-testid": "long-text-field", ...filterDOMProps(props), children: [label && _jsx("label", { htmlFor: id, children: label }), _jsx(TextArea, { id: id, disabled: disabled, name: name, "aria-label": name, onChange: (value, event) => onChange(event.target.value), placeholder: placeholder, ref: inputRef, value: value !== null && value !== void 0 ? value : "" })] }));
}
export default connectField(LongTextField);
//# sourceMappingURL=LongTextField.js.map