import { jsx as _jsx } from "react/jsx-runtime";
import cloneDeep from "lodash/cloneDeep";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { PlusCircleIcon } from "@patternfly/react-icons/dist/js/icons/plus-circle-icon";
import { connectField, filterDOMProps, joinName, useField } from "uniforms";
function ListAddField({ disabled = false, name, value, ...props }) {
    var _a, _b;
    const nameParts = joinName(null, name);
    const parentName = joinName(nameParts.slice(0, -1));
    const parent = useField(parentName, {}, { absoluteName: true })[0];
    const limitNotReached = !disabled && !(parent.maxCount <= ((_b = (_a = parent.value) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : -1));
    return (_jsx(Button, { "data-testid": "list-add-field", variant: "plain", style: { paddingLeft: "0", paddingRight: "0" }, disabled: !limitNotReached, onClick: () => {
            var _a;
            !disabled && limitNotReached && parent.onChange(((_a = parent.value) !== null && _a !== void 0 ? _a : []).concat([cloneDeep(value)]));
        }, ...filterDOMProps(props), children: _jsx(PlusCircleIcon, { color: "#0088ce" }) }));
}
export default connectField(ListAddField, {
    initialValue: false,
    kind: "leaf",
});
//# sourceMappingURL=ListAddField.js.map